% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_dist.R
\name{plot_dot}
\alias{plot_dot}
\title{Dot plots of single indicator with highlighting}
\usage{
plot_dot(
  coin,
  dset,
  iCode,
  Level = NULL,
  ...,
  usel = NULL,
  marker_type = "circle",
  add_stat = NULL,
  stat_label = NULL,
  show_ticks = TRUE,
  plabel = NULL,
  usel_label = TRUE,
  vert_adjust = 0.5
)
}
\arguments{
\item{coin}{The coin}

\item{dset}{The name of the data set to apply the function to, which should be accessible in \code{.$Data}.}

\item{iCode}{Code of indicator or aggregate found in \code{dset}. Required to be of length 1.}

\item{Level}{The level in the hierarchy to extract data from. See \code{\link[=get_data]{get_data()}}.}

\item{...}{Further arguments to pass to \code{\link[=get_data]{get_data()}}, other than those explicitly specified here.}

\item{usel}{A subset of units to highlight.}

\item{marker_type}{The type of marker, either \code{"circle"} (default) or \code{"cross"}, or a marker number to pass to ggplot2 (0-25).}

\item{add_stat}{A statistic to overlay, either \code{"mean"}, \code{"median"} or else a specified value.}

\item{stat_label}{An optional string to use as label at the point specified by \code{add_stat}.}

\item{show_ticks}{Set \code{FALSE} to remove axis ticks.}

\item{plabel}{Controls the labelling of the indicator. If \code{NULL} (default), returns the indicator code.
Otherwise if \code{"iName"}, returns only indicator name, if \code{"iName+unit"}, returns
indicator name plus unit (if found), if \code{"unit"} returns only unit (if found), otherwise if \code{"none"},
displays no text. Finally, any other string can be passed, so e.g. \code{"My indicator"} will display this on the
axis.}

\item{usel_label}{If \code{TRUE} (default) also labels selected units with their unit codes. \code{FALSE} to disable.}

\item{vert_adjust}{Adjusts the vertical height of text labels and stat lines, which matters depending on plot size.
Takes a value between 0 to 2 (higher will probably remove the label from the axis space).}
}
\value{
A ggplot2 plot object.
}
\description{
Plots a single indicator as a line of dots, and optionally highlights selected units and statistics.
This is intended for showing the relative position of units to other units, rather than as a statistical
plot. For the latter, use \code{\link[=plot_dist]{plot_dist()}}.
}
\details{
This function uses ggplot2 to generate plots, so the plot can be further manipulated using ggplot2 commands.
See \verb{vignette("visualisation}) for more details on plotting.

This function replaces the now-defunct \code{plotIndDot()} from COINr < v1.0.
}
\examples{
# build example coin
coin <- build_example_coin(up_to = "new_coin")

# dot plot of LPI, highlighting two countries and with median shown
plot_dot(coin, dset = "Raw", iCode = "LPI", usel = c("JPN", "ESP"),
         add_stat = "median", stat_label = "Median", plabel = "iName+unit")

}
