% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv_zone_area_raster.R
\name{cv_zone_area_raster}
\alias{cv_zone_area_raster}
\title{Gets zones and areas for all grid locations}
\usage{
cv_zone_area_raster()
}
\value{
Returns a \pkg{terra} \code{SpatRaster} object (415 rows x 883 columns x 2 layers) of all Canadian grid locations.
}
\description{
Uses the data frame \code{zone_grid_df}. Returns a raster containing two layers, the zone (1-9) and the area (km^2^) for
each grid location in the CMIP6 files. The raster raster returned has 415 rows (latitudes in 0.1 degrees)
and 883 columns (longitudes in 0.1 degrees). The zone number is used to determine the file(s) to read in
for computing the basin mean precipitation statistics for a given Canadian hydrometric basin. The
}
\examples{
zone_area_grid <- cv_zone_area_raster()
library(terra)
plot(zone_area_grid)

}
\author{
Heba Abdelmoaty Kevin SHook
}
