% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CIplot.R, R/CIplot.default.R, R/CIplot.htest.R,
%   R/CIplot.TukeyHSD.R, R/CIplot.glht.R, R/CIplot.glm.R, R/CIplot.ORci.R,
%   R/CIplot.posthocTGH.R
\name{CIplot}
\alias{CIplot}
\alias{CIplot.default}
\alias{CIplot.htest}
\alias{CIplot.TukeyHSD}
\alias{CIplot.glht}
\alias{CIplot.glm}
\alias{CIplot.ORci}
\alias{CIplot.posthocTGH}
\title{Plot Confidential Interval}
\usage{
CIplot(x, ...)

\method{CIplot}{default}(x, xlog = FALSE, xlim = NULL, xlab = NULL,
  yname = TRUE, las = 0, pch = 21, pcol = 1, pcolbg = "white",
  pcex = 1, conf.level = 0.95, cilty = 1, cilwd = 1, cicol = 1, v,
  vlty = 2, vlwd = 1, vcol = 1, main = NULL, ...)

\method{CIplot}{htest}(x, xlog = FALSE, xlim = NULL, xlab = NULL,
  yname = FALSE, v = NULL, ...)

\method{CIplot}{TukeyHSD}(x, xlab = "Differences in mean", v = 0, ...)

\method{CIplot}{glht}(x, xlab = "Differences in mean", v = 0, ...)

\method{CIplot}{glm}(x, conf.level = 0.95, xlog = TRUE,
  xlab = "Odds Ratio", v = 1, ...)

\method{CIplot}{ORci}(x, xlog = TRUE, xlab = "Odds Ratio", v = 1, ...)

\method{CIplot}{posthocTGH}(x, xlab = "Differences in mean", v = 0, ...)
}
\arguments{
\item{x}{\code{default}: \code{matrix} or \code{data.frame} class
with 3 columns ('any name', \code{lwr}, \code{upr}),
or an object: \code{htest}, \code{TukeyHSD},
\code{glht} (\pkg{multcomp}),
\code{glm} (logistic regression only!)
or \code{posthocTGH} (\pkg{userfriendlyscience}).}

\item{\dots}{other options for x-axis.}

\item{xlog}{(logical) if \code{log} is \code{TRUE},
the x axis is drawn logarithmically.
Default is \code{FALSE}.}

\item{xlim}{the x limits (x1, x2) of the plot.}

\item{xlab}{a title for the plot.}

\item{yname}{If \code{yname} is \code{TRUE},
the name of comparison between groups are shown.}

\item{las}{numeric in {0,1,2,3}; the style of axis labels.
Default is 0. see also \code{par}.}

\item{pch}{plotting 'character', i.e., symbol to use.}

\item{pcol}{color code or name of the points.}

\item{pcolbg}{background (fill) color for the open plot symbols
given by 'pch = 21:25'.}

\item{pcex}{character (or symbol) expansion of points.}

\item{conf.level}{\code{default} and \code{glm} object only.
the confidence interval. Default is 0.95.
see also \code{\link{ORci}}.}

\item{cilty}{line types of conficence intervals.}

\item{cilwd}{line width of conficence intervals.}

\item{cicol}{color code or name of conficence intervals.}

\item{v}{the x-value(s) for vertical line.}

\item{vlty}{line types of vertical line.}

\item{vlwd}{line width of vertical line.}

\item{vcol}{color code or name of vertical line.}

\item{main}{a main title for the plot.}
}
\description{
A function to plot confidential interval for
such as \code{htest}, \code{TukeyHSD},
\code{glht} (\pkg{multcomp}),
\code{glm} (logistic regression only!)
and \code{posthocTGH} (\pkg{userfriendlyscience}) objects.
}
\note{
\code{CIplot} was made based on \code{plot.TukeyHSD}.
 \preformatted{
 #  File src/library/stats/R/TukeyHSD.R
 #  Part of the R package, https://www.R-project.org
 #
 #  Copyright (C) 2000-2001  Douglas M. Bates
 #  Copyright (C) 2002-2015  The R Core Team
}
}
\examples{
##### default (matrix or data.frame)
require(graphics)
x <- matrix(c(3, 1, 5,
              4, 2, 6), 2, 3, byrow = TRUE)
colnames(x) <- c("esti", "lwr", "upr")
rownames(x) <- c("A", "B")
CIplot(x, xlab = "difference", v = 2, las = 1)

##### 'htest' objects
require(graphics)

## t test
set.seed(1234)
a <- rnorm(10, 10, 2); b <- rnorm(10, 8, 2)
x <- t.test(a, b)
CIplot(x)

## binomial test
x <- binom.test(5, 20)
CIplot(x, xlim = c(0, 1))

## Fisher's exact test
x <- matrix(c(10, 7, 8, 9), 2, 2, byrow = TRUE)
res <- fisher.test(x)
CIplot(res, xlog = TRUE)


##### 'TukeyHSD' objects
require(graphics)

## Tukey test
aov1 <- aov(breaks ~ tension + wool, data = warpbreaks)
x <- TukeyHSD(aov1)

oldpar <- par(no.readonly = TRUE)
par(mfrow = c(1, 2))
CIplot(x, las = 1)
par(oldpar)

## example of line type and color
aov1 <- aov(breaks ~ tension, data = warpbreaks)
x <- TukeyHSD(aov1)
CIplot(x, las = 1,
       pcol = 2:4, pcolbg = 2:4, cicol = 2:4,
       vlty = 1, vcol = "gray")

##### 'glht' objects
require(graphics)

## Tukey test
require(multcomp)
aov1 <- aov(breaks ~ tension, data = warpbreaks)
x <- glht(aov1, linfct = mcp(tension = "Tukey"))
CIplot(x, las = 1)

## Dunnett test
x <- glht(aov1, linfct = mcp(tension = "Dunnett"))
CIplot(x, las = 1)


##### 'glm' object: logistic regression only!
## odds ratio
require(graphics)
require(MASS)
data(birthwt)
x <- glm(low ~  age + lwt + smoke + ptl + ht + ui, data = birthwt,
         family = binomial)
CIplot(x, las = 1)


##### 'posthocTGH' object
## Tukey or Games-Howell methos
require(graphics)
if (require(userfriendlyscience)) {
    x <- posthocTGH(warpbreaks$breaks, warpbreaks$tension)
    CIplot(x, las = 1)
}

}
\seealso{
\code{plot}, \code{axis}, \code{points}, \code{par}.
}
\keyword{ORci}
\keyword{TukeyHSD}
\keyword{glht}
\keyword{glm}
\keyword{htest}
\keyword{plot}
\keyword{posthocTGH}
