% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.CIMTx_IPTW.R
\name{summary.CIMTx_IPTW}
\alias{summary.CIMTx_IPTW}
\title{Summarize a CIMTx_IPTW object}
\usage{
\method{summary}{CIMTx_IPTW}(object, ...)
}
\arguments{
\item{object}{a \code{CIMTx_IPTW} object}

\item{...}{further arguments passed to or from other methods.}
}
\value{
a data frame with ATT/ATE effect estimates in terms of
RD, RR and OR.
}
\description{
Summarize a CIMTx_IPTW object
}
\examples{
lp_w_all <-
  c(
    ".4*x1 + .1*x2  - .1*x4 + .1*x5", # w = 1
    ".2 * x1 + .2 * x2  - .2 * x4 - .3 * x5"
  ) # w = 2
nlp_w_all <-
  c(
    "-.5*x1*x4  - .1*x2*x5", # w = 1
    "-.3*x1*x4 + .2*x2*x5"
  ) # w = 2
lp_y_all <- rep(".2*x1 + .3*x2 - .1*x3 - .1*x4 - .2*x5", 3)
nlp_y_all <- rep(".7*x1*x1  - .1*x2*x3", 3)
X_all <- c(
  "rnorm(0, 0.5)", # x1
  "rbeta(2, .4)", # x2
  "runif(0, 0.5)", # x3
  "rweibull(1,2)", # x4
  "rbinom(1, .4)" # x5
)

set.seed(111111)
data <- data_sim(
  sample_size = 300,
  n_trt = 3,
  x = X_all,
  lp_y = lp_y_all,
  nlp_y = nlp_y_all,
  align = FALSE,
  lp_w = lp_w_all,
  nlp_w = nlp_w_all,
  tau = c(-1.5, 0, 1.5),
  delta = c(0.5, 0.5),
  psi = 1
)
iptw_multi_res <- ce_estimate(
  y = data$y, x = data$covariates,
  w = data$w, method = "IPTW-Multinomial", estimand = "ATE"
)
summary(iptw_multi_res)
}
\references{
Hadley Wickham (2019).
\emph{stringr: Simple, Consistent Wrappers for Common String Operations}.
R package version 1.4.0.
URL:\url{https://CRAN.R-project.org/package=stringr}
}
