% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ce_estimate_rams_att.R
\name{ce_estimate_rams_att}
\alias{ce_estimate_rams_att}
\title{Causal inference with multiple treatments using RAMS for ATT effects}
\usage{
ce_estimate_rams_att(y, w, x, method, reference_trt, ...)
}
\arguments{
\item{y}{A numeric vector (0, 1) representing a binary outcome.}

\item{w}{A numeric vector representing the treatment groups.}

\item{x}{A dataframe, including all the covariates but not treatments.}

\item{method}{A character string. Users can selected from the
following methods including \code{"RAMS-Multinomial"},
\code{"RAMS-GBM"}, \code{"RAMS-SL"}.}

\item{reference_trt}{A numeric value indicating
reference treatment group for ATT effect.}

\item{...}{Other parameters that can be passed through to functions.}
}
\value{
A summary of the effect estimates can be obtained
with \code{summary} function.
}
\description{
The function \code{ce_estimate_rams_att} implements
RAMS to estimate ATT effect with
multiple treatments using observational data.
}
\references{
Matthew Cefalu, Greg Ridgeway, Dan McCaffrey, Andrew Morral,
 Beth Ann Griffin and Lane Burgette (2021).
 \emph{twang: Toolkit for Weighting and Analysis of Nonequivalent Groups}.
 R package version 2.5.
 URL:\url{https://CRAN.R-project.org/package=twang}

Venables, W. N. & Ripley, B. D. (2002)
\emph{Modern Applied Statistics with S}.
Fourth Edition. Springer, New York. ISBN 0-387-95457-0

Noah Greifer (2021).
\emph{WeightIt: Weighting for Covariate Balance in Observational Studies}.
R package version 0.12.0.
URL:\url{https://CRAN.R-project.org/package=WeightIt}

Wood, S.N. (2011)
Fast stable restricted maximum likelihood and
marginal likelihood estimation of semiparametric generalized linear models.
\emph{Journal of the Royal Statistical Society (B)} \strong{73}(1):3-36
}
