% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CFO2d.next.R
\name{CFO2d.next}
\alias{CFO2d.next}
\title{Determinate the dose level for the next cohort in the two-dimensional calibration-free odds (2dCFO) design for phase I trials.}
\usage{
CFO2d.next(target, cys, cns, currdose, 
       prior.para = list(alp.prior = target, bet.prior = 1 - target), 
       cutoff.eli = 0.95, early.stop = 0.95, seed = NULL)
}
\arguments{
\item{target}{the target DLT rate.}

\item{cys}{a matrix of the number of DLTs observed for each dose combination.}

\item{cns}{a matrix of the number of patients allocated to each dose combination.}

\item{currdose}{a vector of the current dose indices in the horizontal and vertical direction.}

\item{prior.para}{the prior parameters for a beta distribution, where set as \code{list(alp.prior = target, bet.prior = 1 - target)}
by default, \code{alp.prior} and \code{bet.prior} represent the parameters of the prior distribution for
the true DLT rate at any dose level. This prior distribution is specified as Beta(\code{alpha.prior}, \code{beta.prior}).}

\item{cutoff.eli}{the cutoff to eliminate overly toxic doses for safety. We recommend
the default value of \code{cutoff.eli = 0.95} for general use.}

\item{early.stop}{the threshold value for early stopping. The default value \code{early.stop = 0.95}
generally works well.}

\item{seed}{an integer to be set as the seed of the random number generator for reproducible results. The default value is set to \code{NULL}.}
}
\value{
The \code{CFO2d.next()} function returns a list with the following components:
\itemize{
\item target: the target DLT rate.
\item cys: a 3 by 3 matrix of the number of DLT observed for each dose combination at and around the current dose.
\item cns: a 3 by 3 matrix of the number of patients allocated to each dose combination at and around the current dose.
\item decision: a vector of length 2 representing the recommended decisions for vertical and horizontal
directions, and \code{stop} indicates stopping the experiment.
\item currdose: the current dose combination.
\item nextdose: the recommended dose combination for the next cohort. \code{nextdose = (99, 99)} indicates that the trial is
terminated due to early stopping.
\item overtox: the situation regarding which positions experience over-toxicity. The dose level indicated
by \code{overtox} and all the dose levels above experience over-toxicity. \code{overtox = NA} signifies that the
occurrence of over-toxicity did not happen.
}
}
\description{
In the 2dCFO design for phase I trials, the function is used to determine the dose movement based on the toxicity outcomes of the enrolled cohorts.
}
\details{
In the 2dCFO design, decision-making within the two-dimensional toxicity probability space is conducted by performing two independent one-dimensional
CFO analyses along both the horizontal and vertical axes (Wang et al. 2023).
}
\note{
When the current dose level is the lowest or highest (i.e., at the boundary), the parts in \code{cys} and
\code{cns} where there is no data are filled with \code{NA}. \cr
The dose level indicated by \code{overtox} and all the dose levels above experience over-toxicity, and these dose levels will be eliminated.
}
\examples{
cns <- matrix(c(3, 3, 0,
                0, 6, 0,
                0, 0, 0), 
              nrow = 3, ncol = 3, byrow = TRUE)

cys <- matrix(c(0, 1, 0,
                0, 2, 0,
                0, 0, 0), 
              nrow = 3, ncol = 3, byrow = TRUE)
currdose <- c(2,3)
decision <- CFO2d.next(target = 0.3, cys, cns, currdose = currdose, seed = 1)
summary(decision)

cns <- matrix(c(NA, NA, NA,
                NA, 6, 0,
                NA, 0, 0), 
              nrow = 3, ncol = 3, byrow = TRUE)

cys <- matrix(c(NA, NA, NA,
               NA, 6, 0,
               NA, 0, 0), 
             nrow = 3, ncol = 3, byrow = TRUE)
currdose <- c(1,1)
decision <- CFO2d.next(target = 0.3, cys, cns, currdose = currdose, seed = 1)
summary(decision)

}
\references{
Jin H, Yin G (2022). CFO: Calibration-free odds design for phase I/II clinical trials.
\emph{Statistical Methods in Medical Research}, 31(6), 1051-1066. \cr
Wang W, Jin H, Zhang Y, Yin G (2023). Two-dimensional calibration-free odds (2dCFO)
design for phase I drug-combination trials. \emph{Frontiers in Oncology}, 13, 1294258.
}
\author{
Jialu Fang, Ninghao Zhang, Wenliang Wang, and Guosheng Yin
}
