% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PC2.CFM.R
\name{PC2.CFM}
\alias{PC2.CFM}
\title{PC2 for censored factor models (Top-2 principal components, pure R)}
\usage{
PC2.CFM(
  data,
  m,
  A = NULL,
  D = NULL,
  p = NULL,
  cens.dist = c("normal", "t", "logistic"),
  df = NULL,
  cens.method = c("winsorise", "em"),
  cens_prop = 0.01,
  surv.obj = NULL,
  ctrl = NULL,
  verbose = NULL
)
}
\arguments{
\item{data}{Numeric matrix or data frame of dimension \eqn{n \times p}.}

\item{m}{Number of factors (< p).}

\item{A}{Optional true loading matrix, used only for error calculation.}

\item{D}{Optional true unique-variance diagonal matrix, used only for error calculation.}

\item{p}{Number of variables (deprecated; detected automatically).}

\item{cens.dist}{Error distribution, reserved for future use.}

\item{df}{Degrees of freedom, reserved for future use.}

\item{cens.method}{Censoring handling method; currently only \code{"winsorise"} is implemented.
Defaults to \code{"winsorise"}.}

\item{cens_prop}{Winsorisation proportion, default 0.01.}

\item{surv.obj}{Reserved for future use.}

\item{ctrl}{Reserved for future use.}

\item{verbose}{Reserved for future use.}
}
\value{
\describe{
  \item{AF}{Estimated loading matrix, p × 2.}
  \item{DF}{Estimated unique-variance diagonal matrix, p × p.}
  \item{MSESigmaA}{Mean squared error of loadings (if A is provided).}
  \item{MSESigmaD}{Mean squared error of unique variances (if D is provided).}
  \item{LSigmaA}{Relative error of loadings (if A is provided).}
  \item{LSigmaD}{Relative error of unique variances (if D is provided).}
}
}
\description{
PC2 for censored factor models (Top-2 principal components, pure R)
}
\examples{
\donttest{
library(CFM)
obj <- CFM(n = 500, p = 12, m = 2, cens.dist = "normal")
res <- PC2.CFM(obj$data, A = obj$A, D = obj$D)
print(res$MSESigmaA)
}

}
