% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dummyinstance.R
\name{dummyinstance}
\alias{dummyinstance}
\title{Dummy instance routine to test the sampling procedures}
\usage{
dummyinstance(distr, ..., bias = 0)
}
\arguments{
\item{distr}{name of a function that generates random values
according to a given distribution, e.g., "rnorm", "runif", "rexp" etc.}

\item{...}{additional parameters to be passed down to the function in
\code{distr}. Parameter \code{n} (number of points to generate) is unnecessary
(this routine always forces \code{n = 1}).}

\item{bias}{a bias term to add to the results of the distribution function
(e.g., to set the mean to zero).}
}
\value{
a single numeric value sampled from the desired distribution.
}
\description{
This is a dummy instance routine to test the sampling procedures, in
combination with \code{\link[=dummyalgo]{dummyalgo()}}.
\code{dummyinstance()} receives a parameter \code{distr} containing the name of a
random number generation function (e.g. \code{rnorm}, \code{runif}, \code{rexp} etc.), plus
a variable number of arguments to be passed down to the function in \code{distr}.
}
\examples{
dummyinstance(distr = "rnorm", mean = 10, sd = 1)

# Make a centered (zero-mean) exponential distribution:
lambda = 4

# 10000 observations
set.seed(1234)
y <- numeric(10000)
for (i in 1:10000) y[i] <- dummyinstance(distr = "rexp", rate = lambda,
                                         bias = -1/lambda)
mean(y)
hist(y, breaks = 50, xlim = c(-0.5, 2.5))
}
\seealso{
\code{\link[=dummyalgo]{dummyalgo()}}
}
\author{
Felipe Campelo (\email{fcampelo@ufmg.br},
\email{f.campelo@aston.ac.uk})
}
