% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BioCircos.R
\name{BioCircosHeatmapTrack}
\alias{BioCircosHeatmapTrack}
\title{Create a heatmap track to be added to a BioCircos tracklist}
\usage{
BioCircosHeatmapTrack(trackname, chromosomes, starts, ends, values,
  labels = "", maxRadius = 0.9, minRadius = 0.5,
  color = c("#40B9D4", "#F8B100"), range = 0, ...)
}
\arguments{
\item{trackname}{The name of the new track.}

\item{chromosomes}{A vector containing the chromosomes on which each box is found.
Values should match the chromosome names given in the genome parameter of the BioCircos function.}

\item{starts, ends}{Vectors containing the coordinates on which each box begins or ends.}

\item{values}{A vector of numerical values associated with each box, used to determine the 
height of each bar on the track.}

\item{labels}{One or multiple character objects to label each bar.}

\item{minRadius, maxRadius}{Where the track should begin and end, in proportion of the inner radius of the plot.}

\item{color}{a vector of the colors in hexadecimal RGB format to be mapped to the minimum and 
maximum values of the track.
Colors of intermediate values will be linearly interpolated between this two colors.}

\item{range}{a vector of the values to be mapped to the minimum and maximum colors of the track.
Default to 0, mapping the minimal and maximal values input in the values parameter.}

\item{...}{Ignored}
}
\description{
Heatmaps are defined by the genomic range and the color-associated numerical value
 of each box of the heatmap layer
}
\examples{
BioCircos(BioCircosHeatmapTrack('HmTrack', chromosomes = 1:3, starts = 1e+7*2:4, ends = 2.5e+7*2:4, 
  values = 1:3, labels = c('A ', 'B ', 'C ')))

}
