% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Omega_Indices.R
\name{cat_Omega_H}
\alias{cat_Omega_H}
\title{cat_Omega_H}
\usage{
cat_Omega_H(Lambda, Thresh, Phi = NULL, Denom = NULL)
}
\arguments{
\item{Lambda}{is a matrix of standardized factor loadings}

\item{Thresh}{is a list (indexed by items) of vectors of item thresholds}

\item{Phi}{is the latent variable covariance matrix. Defaults to \code{NULL}, and
the identity matrix will be used. No other options are currently available.}

\item{Denom}{specifies how the variance of the total score will be computed. Defaults
to \code{NULL}, and the model implied total score variance will be used. No other options
are currently available.}
}
\value{
A \code{numeric}, the hierarchical omega reliability estimate for all factors using
the technique of Green and Yang (2009).
}
\description{
Computes hierarchical omega reliability estimate for all factors as described in Rodriguez, Reise, and
Haviland (2016).
}
\details{
\code{cat_Omega_H} is called by \code{\link{bifactorIndices}} and the various convenience functions
for exploratory models and/or Mplus output,
which are the only functions in this package intended for casual users.
}
\examples{
Lambda <- matrix(c(.82, .10,   0,   0,
                   .77, .35,   0,   0,
                   .79, .32,   0,   0,
                   .66, .39,   0,   0,
                   .51,   0, .71,   0,
                   .56,   0, .43,   0,
                   .68,   0, .13,   0,
                   .60,   0, .50,   0,
                   .83,   0,   0, .47,
                   .60,   0,   0, .27,
                   .78,   0,   0, .28,
                   .55,   0,   0, .75),
                   ncol = 4, byrow = TRUE)
colnames(Lambda) <- c("General", "SF1", "SF2", "SF3")

Thresh = list(c(-1, 0, 1),  c(-0.5, 0, 0.5),
              c(0, 1, 2),   c(0, 0.5, 1),
              c(-2, -1, 0), c(-1, -0.5, 0),
              c(-1, 0, 2),  c(-0.5, 0, 1),
              c(-2, 0, 1),  c(-1, 0, 0.5),
              c(-1, 0, 1),  c(-0.5, 0, 0.5))

cat_Omega_H(Lambda, Thresh)

}
\references{
Rodriguez, A., Reise, S. P., & Haviland, M. G. (2016). Evaluating bifactor models:
calculating and interpreting statistical indices. \emph{Psychological Methods, 21}(2),
137 \doi{10.1037/met0000045}.

Green, S. B., & Yang, Y. (2009). Reliability of summed item scores using
structural equation modeling: An alternative to coefficient alpha.
\emph{Psychometrika, 74}(1), 155-167 \doi{10.1007/s11336-008-9099-3}.
}
\seealso{
\code{\link{Omega_H}}, \code{\link{bifactorIndices}}
}
