% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/continuous_2g_pair.R
\name{continuous_2g_pair}
\alias{continuous_2g_pair}
\title{Bivariate analysis for 2 groups for paired data}
\usage{
continuous_2g_pair(
  data,
  groupvar,
  ttest_args = list(),
  wilcox_args = list(),
  flextableformat = TRUE
)
}
\arguments{
\item{data}{Data frame from which variables will be extracted.}

\item{groupvar}{Grouping variable. Must have exactly 2 levels.}

\item{ttest_args}{Arguments to be passed to \code{t.test()} function.}

\item{wilcox_args}{Arguments to be passed to \code{wilcox.test()} function.}

\item{flextableformat}{Logical operator to indicate the output desired. Default is TRUE. When FALSE, function will return a dataframe format.}
}
\value{
A dataframe or flextable with containing p values for paired tests along with statistics for normality and homocedasticity.
}
\description{
Automatic paired test for continuous variables for 2 groups. Variable names can be assigned using \code{\link[table1:label]{table1::label()}} function.
}
\examples{
data <- data.frame(group = rep(letters[1:2], 30),
                   var1 = rnorm(60, mean = 15, sd = 5),
                  var2 = rnorm(60, mean = 20, sd = 2),
                  var3 = rnorm(60, mean = 10, sd = 1),
                  var4 = rnorm(60, mean = 5, sd =2))
data$group<-as.factor(data$group)

continuous_2g_pair(data = data, groupvar = "group")

# Set names to variables
if(requireNamespace("table1")){
table1::label(data$var1) <- "Variable 1"
table1::label(data$var2) <- "Variable 2"
table1::label(data$var3) <- "Variable 3"
table1::label(data$var4) <- "Variable 4"

continuous_2g_pair(data = data, groupvar = "group", flextableformat = FALSE)
}

}
