/*
 * Decompiled with CFR 0.152.
 */
package dr.util;

import dr.util.FirstOrderFiniteDifferenceTransform;
import dr.util.Transform;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.Reportable;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;

public class InverseFirstOrderFiniteDifferenceTransform
extends Transform.MultivariateTransform
implements Reportable {
    private final Transform.UnivariableTransform incrementTransform;
    private final FirstOrderFiniteDifferenceTransform firstOrderFiniteDifferenceTransform;
    public static final String NAME = "inverseFirstOrderFiniteDifferenceTransform";
    public static final String INCREMENT_TRANSFORM = "type";
    public static final String DIMENSION = "dim";
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        private XMLSyntaxRule[] rules = new XMLSyntaxRule[]{AttributeRule.newIntegerRule("dim", false), AttributeRule.newStringRule("type", true, "The transformation on the increments.")};

        @Override
        public String getParserName() {
            return InverseFirstOrderFiniteDifferenceTransform.NAME;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            Transform.UnivariableTransform univariableTransform;
            double d = xMLObject.getAttribute("upper", 1.0);
            double d2 = xMLObject.getAttribute("lower", 0.0);
            String string = xMLObject.getAttribute(InverseFirstOrderFiniteDifferenceTransform.INCREMENT_TRANSFORM, "none");
            if (string.equalsIgnoreCase("none")) {
                univariableTransform = new Transform.NoTransform();
            } else if (string.equalsIgnoreCase("log")) {
                univariableTransform = new Transform.LogTransform();
            } else if (string.equalsIgnoreCase("logit")) {
                univariableTransform = new Transform.ScaledLogitTransform(d2, d);
            } else {
                throw new RuntimeException("Invalid option for type");
            }
            int n = xMLObject.getIntegerAttribute(InverseFirstOrderFiniteDifferenceTransform.DIMENSION);
            return new InverseFirstOrderFiniteDifferenceTransform(n, univariableTransform);
        }

        @Override
        public String getParserDescription() {
            return "For vector X, creates new vector Y with Y[i] = incrementTransform^-1(sum_j=1^i X[j]).";
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }

        @Override
        public Class getReturnType() {
            return Transform.MultivariateTransform.class;
        }
    };

    @Override
    public String getReport() {
        return null;
    }

    public InverseFirstOrderFiniteDifferenceTransform(int n, Transform.UnivariableTransform univariableTransform) {
        super(n);
        this.incrementTransform = univariableTransform;
        this.firstOrderFiniteDifferenceTransform = new FirstOrderFiniteDifferenceTransform(n, univariableTransform);
    }

    @Override
    protected double[] transform(double[] dArray) {
        return this.firstOrderFiniteDifferenceTransform.inverse(dArray);
    }

    @Override
    public double[] updateDiagonalHessianLogDensity(double[] dArray, double[] dArray2, double[] dArray3, int n, int n2) {
        throw new RuntimeException("not implemented yet");
    }

    @Override
    public double[][] updateHessianLogDensity(double[][] dArray, double[][] dArray2, double[] dArray3, double[] dArray4, int n, int n2) {
        throw new RuntimeException("not implemented yet");
    }

    @Override
    public double[] updateGradientInverseUnWeightedLogDensity(double[] dArray, double[] dArray2, int n, int n2) {
        throw new RuntimeException("not implemented yet");
    }

    @Override
    public double[] updateGradientUnWeightedLogDensity(double[] dArray, double[] dArray2, int n, int n2) {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    protected double[] inverse(double[] dArray) {
        return this.firstOrderFiniteDifferenceTransform.transform(dArray);
    }

    @Override
    public double[] inverse(double[] dArray, int n, int n2, double d) {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public boolean isInInteriorDomain(double[] dArray) {
        return this.incrementTransform.isInInteriorDomain(dArray, 0, this.dim);
    }

    @Override
    public String getTransformName() {
        return "inverseFirstOrderFiniteDifference";
    }

    @Override
    public double[] gradient(double[] dArray, int n, int n2) {
        throw new RuntimeException("Not yet implemented.");
    }

    @Override
    public double[] gradientInverse(double[] dArray, int n, int n2) {
        throw new RuntimeException("Not yet implemented.");
    }

    @Override
    protected double[] updateGradientLogDensity(double[] dArray, double[] dArray2) {
        double[] dArray3 = new double[this.dim];
        double[] dArray4 = this.transform(dArray2);
        double[] dArray5 = new double[this.dim];
        for (int i = 0; i < this.dim - 1; ++i) {
            dArray5[i] = (dArray[i] - dArray[i + 1]) * this.incrementTransform.derivativeOfTransformWrtValue(dArray4[i]);
        }
        dArray5[this.dim - 1] = dArray[this.dim - 1] * this.incrementTransform.derivativeOfTransformWrtValue(dArray4[this.dim - 1]);
        double[] dArray6 = this.getGradientLogJacobianInverse(dArray4);
        for (int i = 0; i < this.dim; ++i) {
            dArray3[i] = dArray5[i] + dArray6[i];
        }
        return dArray3;
    }

    @Override
    public double getLogJacobian(double[] dArray) {
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            d += Math.log(this.incrementTransform.gradientInverse(d2 += dArray[i]));
        }
        return d;
    }

    @Override
    public double[] getGradientLogJacobianInverse(double[] dArray) {
        double[] dArray2 = new double[this.dim];
        for (int i = 0; i < this.dim; ++i) {
            dArray2[i] = 1.0 / this.incrementTransform.derivativeOfTransformWrtValue(dArray[i]) * this.incrementTransform.secondDerivativeOfTransformWrtValue(dArray[i]);
        }
        return dArray2;
    }

    @Override
    public double[][] computeJacobianMatrixInverse(double[] dArray) {
        double[][] dArray2 = new double[this.dim][this.dim];
        for (int i = 0; i < this.dim - 1; ++i) {
            dArray2[i][i] = this.incrementTransform.derivativeOfTransformWrtValue(dArray[i]);
            dArray2[i][i + 1] = -this.incrementTransform.derivativeOfTransformWrtValue(dArray[i]);
        }
        dArray2[this.dim - 1][this.dim - 1] = this.incrementTransform.derivativeOfTransformWrtValue(dArray[this.dim - 1]);
        return dArray2;
    }
}

