/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.operators.rejection;

import dr.math.matrixAlgebra.CholeskyDecomposition;
import dr.math.matrixAlgebra.IllegalDimension;
import dr.math.matrixAlgebra.Matrix;

public interface AcceptCondition {
    public boolean satisfiesCondition(double[] var1);

    public static enum SimpleAcceptCondition implements AcceptCondition
    {
        DescendingAbsoluteValue("descendingAbsoluteValue"){

            @Override
            public boolean satisfiesCondition(double[] dArray) {
                for (int i = 1; i < dArray.length; ++i) {
                    if (!(Math.abs(dArray[i - 1]) < Math.abs(dArray[i]))) continue;
                    return false;
                }
                return true;
            }
        }
        ,
        AlternatingSigns("descendingAlternatingSigns"){

            @Override
            public boolean satisfiesCondition(double[] dArray) {
                for (int i = 1; i < dArray.length; ++i) {
                    Boolean bl = dArray[i] > 0.0;
                    Boolean bl2 = dArray[i - 1] > 0.0;
                    if (!(Math.abs(dArray[i - 1]) < Math.abs(dArray[i])) && bl != bl2) continue;
                    return false;
                }
                return true;
            }
        }
        ,
        PositiveDefinite("positiveDefinite"){

            @Override
            public boolean satisfiesCondition(double[] dArray) {
                CholeskyDecomposition choleskyDecomposition;
                int n = (int)Math.sqrt(dArray.length);
                Matrix matrix = new Matrix(dArray, n, n);
                try {
                    choleskyDecomposition = new CholeskyDecomposition(matrix);
                }
                catch (IllegalDimension illegalDimension) {
                    throw new RuntimeException("Matrix must be square");
                }
                return choleskyDecomposition.isSPD();
            }
        };

        private final String name;

        private SimpleAcceptCondition(String string2) {
            this.name = string2;
        }

        public String getName() {
            return this.name;
        }

        @Override
        public abstract boolean satisfiesCondition(double[] var1);
    }
}

