/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.tree;

import dr.evomodel.tree.HiddenLinkageModel;
import dr.inference.loggers.LogFormatter;
import dr.inference.loggers.MCLogger;

public class HiddenLinkageLogger
extends MCLogger {
    HiddenLinkageModel hlm;

    public HiddenLinkageLogger(HiddenLinkageModel hiddenLinkageModel, LogFormatter logFormatter, int n) {
        super(logFormatter, n, false);
        this.hlm = hiddenLinkageModel;
    }

    @Override
    public void startLogging() {
        String[] stringArray = new String[1 + this.hlm.getData().getReadsTaxa().getTaxonCount()];
        stringArray[0] = "iter";
        for (int i = 1; i < stringArray.length; ++i) {
            stringArray[i] = this.hlm.getData().getReadsTaxa().getTaxonId(i - 1);
        }
        this.logLabels(stringArray);
    }

    @Override
    public void log(long l) {
        if (l % this.logEvery != 0L) {
            return;
        }
        String[] stringArray = new String[1 + this.hlm.getData().getReadsTaxa().getTaxonCount()];
        stringArray[0] = new Long(l).toString();
        for (int i = 1; i < stringArray.length; ++i) {
            stringArray[i] = new Integer(this.hlm.getLinkageGroupId(this.hlm.getData().getReadsTaxa().getTaxon(i - 1))).toString();
        }
        this.logValues(stringArray);
    }
}

