/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.continuous.plink;

import dr.evolution.util.Taxa;
import dr.evolution.util.Taxon;
import dr.evolution.util.TaxonList;
import dr.util.Author;
import dr.util.Citable;
import dr.util.Citation;
import dr.util.Identifiable;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.OrRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLParser;
import dr.xml.XMLSyntaxRule;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Logger;

public class PlinkImporter
implements Citable {
    private TaxonList taxonList = null;
    private Map<String, List<Double>> taxonHash = new HashMap<String, List<Double>>();
    private Map<String, Integer> taxonCounts = new HashMap<String, Integer>();
    private List<Integer> remove = new ArrayList<Integer>();
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        public static final String PLINK_IMPORT = "plinkImport";
        public static final String INPUT_FILE_NAME = "fileName";
        public static final String TRAIT_NAME = "traitName";
        private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{AttributeRule.newStringRule("fileName", false, "The name of the file containing the plink table"), new OrRule(new ElementRule(Taxa.class, 1, Integer.MAX_VALUE), new ElementRule(Taxon.class, 1, Integer.MAX_VALUE)), AttributeRule.newStringRule("traitName")};

        @Override
        public String getParserName() {
            return PLINK_IMPORT;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            PlinkImporter plinkImporter;
            FileReader fileReader = XMLParser.getFileReader(xMLObject, INPUT_FILE_NAME);
            Logger.getLogger("dr.evomodel.continuous").info("Attempting to read PLINK file...\n");
            try {
                plinkImporter = new PlinkImporter(fileReader);
                Logger.getLogger("dr.evomodel.continuous").info(plinkImporter.toStatisticsString());
            }
            catch (IOException iOException) {
                throw new XMLParseException("Unable to read plink data from file, " + fileReader.getEncoding());
            }
            Taxa taxa = new Taxa();
            for (int i = 0; i < xMLObject.getChildCount(); ++i) {
                Identifiable identifiable;
                Object object = xMLObject.getChild(i);
                if (object instanceof Taxon) {
                    identifiable = (Taxon)object;
                    taxa.addTaxon((Taxon)identifiable);
                    continue;
                }
                if (object instanceof TaxonList) {
                    identifiable = (TaxonList)object;
                    for (int j = 0; j < identifiable.getTaxonCount(); ++j) {
                        taxa.addTaxon(identifiable.getTaxon(j));
                    }
                    continue;
                }
                this.throwUnrecognizedElement(xMLObject);
            }
            plinkImporter.addTaxonAttribute(taxa, xMLObject.getAttribute(TRAIT_NAME, "null"));
            return plinkImporter;
        }

        @Override
        public String getParserDescription() {
            return "Provides the likelihood of pairwise distance given vectors of coordinatesfor points according to the multidimensional scaling scheme of XXX & Rafferty (xxxx).";
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }

        @Override
        public Class getReturnType() {
            return PlinkImporter.class;
        }
    };
    private static final boolean DEBUG = false;
    private boolean removeMissingLoci = true;

    public PlinkImporter(Reader reader) throws IOException {
        this.parse(reader);
    }

    @Override
    public Citation.Category getCategory() {
        return Citation.Category.DATA_MODELS;
    }

    @Override
    public String getDescription() {
        return "PLink";
    }

    @Override
    public List<Citation> getCitations() {
        return Arrays.asList(new Citation(new Author[]{new Author("MA", "Suchard"), new Author("A", "Boyko")}, Citation.Status.IN_PREPARATION));
    }

    private String formatTransformedValue(double d) {
        return String.format("%+4.3e", d);
    }

    private String makeStringAttribute(List<Double> list) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        for (int i = 0; i < list.size(); ++i) {
            if (this.remove.contains(i)) continue;
            if (!bl) {
                stringBuffer.append(" ");
            } else {
                bl = false;
            }
            stringBuffer.append(this.formatTransformedValue(list.get(i)));
        }
        return stringBuffer.toString();
    }

    private void transformRow(String string, Map<String, List<Double>> map, Map<String, Integer> map2, List<Integer> list) {
        ArrayList<Double> arrayList;
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        stringTokenizer.nextToken();
        stringTokenizer.nextToken();
        String string2 = stringTokenizer.nextToken();
        int n = Integer.parseInt(stringTokenizer.nextToken());
        int n2 = Integer.parseInt(stringTokenizer.nextToken());
        stringTokenizer.nextToken();
        int n3 = Integer.parseInt(stringTokenizer.nextToken());
        int n4 = Integer.parseInt(stringTokenizer.nextToken());
        int n5 = n4 - n3;
        double d = this.transform(n3, n5);
        if (Double.isNaN(d)) {
            arrayList = new StringBuffer();
            ((StringBuffer)((Object)arrayList)).append("PLINK line: " + string + " generates invalid frequency estimate;");
            if (this.removeMissingLoci) {
                ((StringBuffer)((Object)arrayList)).append(" marking loci for removal from analysis");
                List<Double> list2 = map.get(string2);
                list.add(list2.size());
            } else {
                ((StringBuffer)((Object)arrayList)).append(" filling in with default value");
                d = this.defaultMissingValue();
            }
            Logger.getLogger("dr.evomodel.continuous").warning(((StringBuffer)((Object)arrayList)).toString());
        }
        if ((arrayList = map.get(string2)) == null) {
            arrayList = new ArrayList<Double>();
            map.put(string2, arrayList);
            map2.put(string2, 1);
        } else {
            map2.put(string2, map2.get(string2) + 1);
        }
        arrayList.add(d);
    }

    public String toStatisticsString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("PLINK importer read ");
        stringBuffer.append(this.taxonHash.keySet().size()).append(" taxa with entry counts:\n");
        for (String string : this.taxonHash.keySet()) {
            stringBuffer.append("\t");
            stringBuffer.append(this.taxonCounts.get(string));
            stringBuffer.append(" = ").append(string).append(this.taxonHash.get(string).size()).append("\n");
        }
        stringBuffer.append("\tPlease cite:\n");
        stringBuffer.append(Citable.Utils.getCitationString(this));
        return stringBuffer.toString();
    }

    public String toString() {
        return this.toTaxonBlockString();
    }

    public void parse(Reader reader) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(reader);
        String string = bufferedReader.readLine();
        if (string == null) {
            throw new IllegalArgumentException("Empty file");
        }
        string = bufferedReader.readLine();
        while (string != null) {
            this.transformRow(string, this.taxonHash, this.taxonCounts, this.remove);
            string = bufferedReader.readLine();
        }
        if (this.remove.size() > 0) {
            Logger.getLogger("dr.evomodel.continuous").warning("Removing " + this.remove.size() + " loci from analysis...");
        }
    }

    public void addTaxonAttribute(TaxonList taxonList, String string) {
        this.taxonList = new Taxa();
        for (Taxon taxon : taxonList) {
            List<Double> list = this.taxonHash.get(taxon.getId());
            if (list == null) {
                Logger.getLogger("dr.evolution").warning("Taxon " + taxon.getId() + " not found in PLINK data");
                continue;
            }
            String string2 = this.makeStringAttribute(list);
            ((Taxa)this.taxonList).addTaxon(taxon);
            taxon.setAttribute(string, string2);
        }
    }

    public String toTaxonBlockString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.taxonList != null) {
            for (Taxon taxon : this.taxonList) {
                stringBuffer.append("<taxon id=\"").append(taxon.getId()).append("\">\n");
                Iterator<String> iterator = taxon.getAttributeNames();
                while (iterator.hasNext()) {
                    String string = iterator.next();
                    stringBuffer.append("\t<attribute name=\"").append(string).append("\"> ");
                    stringBuffer.append(taxon.getAttribute(string));
                    stringBuffer.append(" </attribute>\n");
                }
                stringBuffer.append("</taxon>\n\n");
            }
        }
        return stringBuffer.toString();
    }

    private double innerTransform(double d) {
        return Math.log(d / (1.0 - d));
    }

    private double defaultMissingValue() {
        return 0.0;
    }

    private double transform(int n, int n2) {
        int n3 = n + n2;
        double d = 0.5 / (double)n3;
        double d2 = n == 0 ? d : (n2 == 0 ? 1.0 - d : (double)n / (double)n3);
        return this.innerTransform(d2);
    }
}

