% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getVolume.R
\name{getVolume}
\alias{getVolume}
\title{Calculate posterior volume}
\usage{
getVolume(sampler, prior = F, method = "MVN", ...)
}
\arguments{
\item{sampler}{an object of superclass bayesianOutput or any other class that has the getSample function implemented (e.g. Matrix)}

\item{prior}{schould also prior volume be calculated}

\item{method}{method for volume estimation. Currently, the only option is "MVN"}

\item{...}{additional parameters to pass on to the \code{\link{getSample}}}
}
\description{
Calculate posterior volume
}
\details{
The idea of this function is to provide an estimate of the "posterior volume", i.e. how "broad" the posterior is. One potential application is to the overall reduction of parametric uncertainty between different data types, or between prior and posterior.

Implemented methods for volume estimation:

Option "MVN" - in this option, the volume is calculated as the determinant of the covariance matrix of the prior / posterior sample.
}
\examples{
bayesianSetup = createBayesianSetup(
  likelihood = generateTestDensityMultiNormal(sigma = "no correlation"), 
  lower = rep(-10, 3), upper = rep(10, 3))

out <- runMCMC(bayesianSetup = bayesianSetup, sampler = "Metropolis", 
               settings = list(iterations = 2000, message = FALSE))

getVolume(out, prior = TRUE)

bayesianSetup = createBayesianSetup(
  likelihood = generateTestDensityMultiNormal(sigma = "strongcorrelation"), 
  lower = rep(-10, 3), upper = rep(10, 3))

out <- runMCMC(bayesianSetup = bayesianSetup, sampler = "Metropolis", 
               settings = list(iterations = 2000, message = FALSE))

getVolume(out, prior = TRUE)

}
\author{
Florian Hartig
}
