% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WAIC.R
\name{WAIC}
\alias{WAIC}
\title{calculates the WAIC}
\usage{
WAIC(bayesianOutput, numSamples = 1000, ...)
}
\arguments{
\item{bayesianOutput}{an object of class BayesianOutput. Must implement a log-likelihood density function that can return point-wise log-likelihood values ("sum" argument).}

\item{numSamples}{the number of samples to calculate the WAIC}

\item{...}{optional values to be passed on the the getSample function}
}
\description{
calculates the WAIC
}
\details{
The WAIC is constructed as
\deqn{WAIC = -2 * (lppd - p_{WAIC})}

The lppd (log pointwise predictive density), defined in Gelman et al., 2013, eq. 4 as

\deqn{lppd = \sum_{i=1}^n \log \left(\frac{1}{S} \sum_{s=1}^S p(y_i | \theta^s)\right)}

The value of \eqn{p_WAIC} can be calculated in two ways, the method used is determined by the
\code{method} argument.

Method 1 is defined as,
\deqn{p_{WAIC1} = 2 \sum_{i=1}^{n} (\log (\frac{1}{S} \sum_{s=1}^{S} p(y_i \ \theta^s)) - \frac{1}{S} \sum_{s = 1}^{S} \log p(y_i | \theta^s))}
Method 2 is defined as,
\deqn{p_{WAIC2} = 2 \sum_{i=1}^{n} V_{s=1}^{S} (\log p(y_i | \theta^s))}
where  \eqn{V_{s=1}^{S}} is the sample variance.
}
\note{
The function requires that the likelihood passed on to BayesianSetup contains the option sum = T/F, with defaul F. If set to true, the likelihood for each data point must be returned.
}
\examples{
bayesianSetup <- createBayesianSetup(likelihood = testDensityNormal, 
                                     prior = createUniformPrior(lower = rep(-10,2),
                                                                upper = rep(10,2)))

# likelihood density needs to have option sum = FALSE

testDensityNormal(c(1,1,1), sum = FALSE)
bayesianSetup$likelihood$density(c(1,1,1), sum = FALSE)
bayesianSetup$likelihood$density(matrix(rep(1,9), ncol = 3), sum = FALSE)

# running MCMC

out = runMCMC(bayesianSetup = bayesianSetup)

WAIC(out)
}
\references{
Gelman, Andrew and Jessica Hwang and Aki Vehtari (2013), "Understanding Predictive Information Criteria for Bayesian Models," \url{http://www.stat.columbia.edu/~gelman/research/unpublished/waic_understand_final.pdf}.

Watanabe, S. (2010). "Asymptotic Equivalence of Bayes Cross Validation and Widely Applicable Information Criterion in Singular Learning Theory", Journal of Machine Learning Research, \url{https://www.jmlr.org/papers/v11/watanabe10a.html}.
}
\seealso{
\code{\link{DIC}}, \code{\link{MAP}}, \code{\link{marginalLikelihood}}
}
\author{
Florian Hartig
}
