% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util.R
\name{do_QC}
\alias{do_QC}
\title{Mask out invalid data}
\usage{
do_QC(BOLD, meanTol = 1e-06, varTol = 1e-06, medianToo = TRUE, verbose = TRUE)
}
\arguments{
\item{BOLD}{A session-length list of \eqn{T \times V} numeric BOLD data, where
\eqn{T} is the number of timepoints and \eqn{V} is the number of locations.}

\item{meanTol, varTol}{Tolerance for mean and variance of each data location.
Locations which do not meet these thresholds are masked out of the analysis.
Defaults: \code{1e-6}.}

\item{medianToo}{Also mask out locations with a median value below
\code{meanTol}? Default: \code{TRUE}.}

\item{verbose}{Print messages counting how many locations are removed?
Default: \code{TRUE}.}
}
\value{
A logical vector indicating locations that are valid across all sessions.
}
\description{
Mask out data locations that are invalid (missing data, low mean, or low
variance) for any session.
}
\examples{
nT <- 30
nV <- 400
BOLD1 <- matrix(rnorm(nT*nV), nrow=nT)
BOLD1[,seq(30,50)] <- NA
BOLD2 <- matrix(rnorm(nT*nV), nrow=nT)
BOLD2[,65] <- BOLD2[,65] / 1e10
BOLD <- list(sess1=BOLD1, sess2=BOLD2)
do_QC(BOLD)

}
