% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssdBFr.R
\name{porsBFr}
\alias{porsBFr}
\title{Probability of replication success based on replication Bayes factor}
\usage{
porsBFr(level, dprior, sr, paradox = TRUE)
}
\arguments{
\item{level}{Bayes factor level below which replication success is achieved}

\item{dprior}{Design prior object}

\item{sr}{Replication standard error}

\item{paradox}{Should the probability of replication success be computed
allowing for the replication paradox (replication success when the effect
estimates from original and replication study have a different sign)?
Defaults to \code{TRUE}}
}
\value{
The probability to achieve replication success
}
\description{
This function computes the probability to achieve replication
    success based on the replication Bayes factor. The replication Bayes
    factor is assumed to be oriented so that values below one indicate
    replication success, whereas values above one indicate evidence for the
    null hypothesis.
}
\examples{
## specify design prior
to1 <- 0.2
so1 <- 0.05
dprior <- designPrior(to = to1, so = so1, tau = 0.03)
porsBFr(level = 1/10, dprior = dprior, sr = c(0.05, 0.04))

}
\references{
Pawel, S., Consonni, G., and Held, L. (2022). Bayesian approaches to
designing replication studies. arXiv preprint.
\doi{10.48550/arXiv.2211.02552}

Verhagen, J. and Wagenmakers, E. J. (2014). Bayesian tests to quantify the result
of a replication attempt. Journal of Experimental Psychology: General,
145:1457-1475. \doi{10.1037/a0036731}

Ly, A., Etz, A., Marsman, M., & Wagenmakers, E.-J. (2018). Replication Bayes
factors from evidence updating. Behavior Research Methods, 51(6), 2498-2508.
\doi{10.3758/s13428-018-1092-x}
}
\author{
Samuel Pawel
}
