% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/designPrior.R
\name{designPrior}
\alias{designPrior}
\title{Design prior for effect size}
\usage{
designPrior(
  to,
  so,
  mu = 0,
  sp = Inf,
  tau = 0,
  g = sp^2/(tau^2 + so^2),
  h = tau^2/so^2,
  type = c(NA, "conditional", "predictive", "EB")
)
}
\arguments{
\item{to}{Effect estimate from original study}

\item{so}{Standard error of effect estimate from original study}

\item{mu}{The initial prior mean. Defaults to \code{0}}

\item{sp}{The initial prior standard deviation. Defaults to \code{Inf} (an
improper uniform prior)}

\item{tau}{The initial prior heterogeneity standard deviation. Defaults to
\code{0} (no heterogeneity)}

\item{g}{The relative initial prior variance \code{g} =
\code{sp^2}/(\code{tau^2} + \code{so^2}) (alternative parametrization of
prior standard deviation \code{sp})}

\item{h}{The relative initial prior heterogeneity variance \code{h} =
\code{tau^2}/\code{so^2} (alternative parametrization of prior
heterogeneity standard deviation \code{tau})}

\item{type}{Shortcut for special parameter combinations. The available
options are \code{NA}, \code{"conditional"}, \code{"predictive"}, and
\code{"EB"} (see details). Defaults to \code{NA}}
}
\value{
Returns an object of class \code{"designPrior"} which is a list containing:

\tabular{ll}{
   \code{dpMean} \tab The computed mean of the design prior \cr
   \tab \cr
   \code{dpVar} \tab The computed variance of the design prior \cr
   \tab \cr
   \code{to} \tab The specified original effect estimate \cr
   \tab \cr
   \code{so} \tab The specified original standard error \cr
   \tab \cr
   \code{mu} \tab The specified mean of the initial prior \cr
   \tab \cr
   \code{sp} \tab The specified standard deviation of the initial prior \cr
   \tab \cr
   \code{tau} \tab The specified heterogeneity variance \cr
}
}
\description{
Creates a design prior for the effect size which can then be
    used for power and sample size calculations of a replication study. The
    design prior is obtained from updating an initial prior for the effect
    size by the data from the original study. A normal-normal hierarchical
    model is assumed, see Pawel et al. (2022) for details.
}
\details{
The \code{"conditional"} design prior corresponds to a point mass at
    the original effect estimate, i.e., assuming that the true effect size is
    equal to the original effect estimate. The \code{"predictive"} design
    prior is obtained from updating a uniform initial prior by the likelihood
    of the original data. The \code{"EB"} design prior is obtained by
    empirical Bayes estimation of the variance of the normal prior and
    induces adaptive shrinkage that depends on the p-value of the original
    effect estimate.
}
\examples{
designPrior(to = 1.1, so = 1)
}
\references{
Pawel, S., Consonni, G., and Held, L. (2022). Bayesian approaches to
designing replication studies. arXiv preprint.
\doi{10.48550/arXiv.2211.02552}
}
\seealso{
\code{\link{pors}}, \code{\link{ssd}}
}
\author{
Samuel Pawel
}
