% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BF_users_functions.r
\name{BFpower.t.test_one_sample}
\alias{BFpower.t.test_one_sample}
\title{Sample size determination for one-sample Bayesian t-test}
\usage{
BFpower.t.test_one_sample(
  hypothesis = NULL,
  e = NULL,
  interval = NULL,
  D = NULL,
  target = NULL,
  alpha = NULL,
  model = NULL,
  location = NULL,
  scale = NULL,
  dff = NULL,
  model_d = NULL,
  location_d = NULL,
  scale_d = NULL,
  dff_d = NULL,
  de_an_prior = NULL,
  N = NULL,
  mode_bf = NULL,
  direct = NULL
)
}
\arguments{
\item{hypothesis}{The hypothesis being tested (e.g., two-sided \code{"!="}, right-sided \code{">"}, left-sided \code{"<"}).}

\item{e}{The bounds for the interval Bayes factor (used when \code{interval = 0}).}

\item{interval}{Integer (1 or 0). If \code{1}, Bayes factor with a point null against a composite alternative hypothesis;
otherwise Bayes factor with interval null and alternative hypotheses.}

\item{D}{The bound of compelling evidence.}

\item{target}{The targeted true positive rate (if \code{direct = "h1"}) or true negative rate (if \code{direct = "h0"}).}

\item{alpha}{The targeted false positive rate (if \code{direct = "h1"}) or false negative rate (if \code{direct = "h0"}).}

\item{model}{Statistical model of the analysis prior under the alternative hypothesis: Normal distribution (\code{"Normal"}), Normal moment (\code{"NLP"}), or scaled t (\code{"t-distribution"}).}

\item{location}{Location parameter for the analysis prior under the alternative hypothesis.}

\item{scale}{Scale parameter for the analysis prior under the alternative hypothesis.}

\item{dff}{Degrees of freedom for the analysis prior under the alternative hypothesis (if applicable).}

\item{model_d}{Statistical model of the design prior under the alternative hypothesis: Normal distribution (\code{"Normal"}), Normal moment (\code{"NLP"}), or scaled t (\code{"t-distribution"}).}

\item{location_d}{Location parameter for the design prior under the alternative hypothesis.}

\item{scale_d}{Scale parameter for the design prior under the alternative hypothesis.}

\item{dff_d}{Degrees of freedom parameter for the design prior under the alternative hypothesis.}

\item{de_an_prior}{Integer (0 or 1). If 1, analysis and design priors under the alternative are the same; if 0, they are not.}

\item{N}{Sample size.}

\item{mode_bf}{Integer (1 or 2). If \code{1}, sample size determination; if \code{2}, \code{N} is used for the calculation of probabilities of compelling and misleading evidence.}

\item{direct}{If \code{"h1"}, controlling true/false positive rates; if \code{"h0"}, controlling true/false negative rates.}
}
\value{
A data frame with the following columns:
\itemize{
\item \code{p(BF10 > D | H1)}: Probability of obtaining compelling evidence
in favor of the alternative hypothesis when the alternative is true.
\item \code{p(BF01 > D | H1)}: Probability of obtaining misleading evidence
in favor of the null hypothesis when the alternative is true.
\item \code{p(BF01 > D | H0)}: Probability of obtaining compelling evidence
in favor of the null hypothesis when the null is true.
\item \code{p(BF10 > D | H0)}: Probability of obtaining misleading evidence
in favor of the alternative hypothesis when the null is true.
\item \code{Required N}: The required sample size or the sample size input by the users.
}
If sample size determination fails, the function returns \code{NULL}.
}
\description{
Perform sample size determination or the calculation of compelling and misleading evidence.
}
\examples{
BFpower.t.test_one_sample(
  hypothesis = "!=",
  interval = 1,
  D = 3,
  target = 0.8,
  alpha = 0.05,
  model = "t-distribution",
  location = 0,
  scale = 0.707,
  dff = 1,
  de_an_prior = 1,
  N = NULL,
  mode_bf = 1,
  direct = "h1"
)

}
