% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PiecewiseBayesSelect.R
\name{PiecewiseBayesSelect}
\alias{PiecewiseBayesSelect}
\title{PiecewiseBayesSelect}
\usage{
PiecewiseBayesSelect(Y1, I1, X, hyperparameters, beta1start, B, inc, Path, burn)
}
\arguments{
\item{Y1}{Vector Containing  event times (or censoring time due to death/censoring)}

\item{I1}{Vector Containing  event indicators (1 if l event for a patient, 0 otherwise)}

\item{X}{Matrix of Patient Covariates, the last inc are left out of the selection procedure}

\item{hyperparameters}{List containing 11 hyperparameters and four starting values. In order they are: psi-the swap rate of the SVSS algorithm.
c-parameter involved in Sigma matrix for selection. z1a, z1b - beta hyper parameters on probability of inclusion for each of the three hazard functions.
a1,b1- hyperparameters on sigma_lambda.
 clam1- spatial dependency of baseline hazard (between 0 and 1) for the  hazard function.
  Alpha1 - The parameter for the number of split points in the hazard (must be whole number).
  J1max - Maximum number of split points allowed (must be whole number).
  J1- Starting number of split points.  cl1 -Tuning parameter for log baseline hazard height sampler.}

\item{beta1start}{Starting Values for Beta1}

\item{B}{Number of iterations}

\item{inc}{Number of variables left out of selection}

\item{Path}{Where to save posterior samples}

\item{burn}{percent of posterior sample to burn in (burn*B must be a whole number)}
}
\description{
PiecewiseBayesSelect
}
\examples{
##Randomly Generate Semicompeting Risks Data
####Generates random patient time, indicator and covariates.
n=100
Y1=runif(n,0,100)
I1=rbinom(n,1,.5)
library(mvtnorm)
X=rmvnorm(n,rep(0,13),diag(13))
####Read in Hyperparameters
##Swap Rate
psi=.5
c=20
###Eta Beta function probabilities
z1a=.4
z1b=1.6
####Hierarchical lam params
###Sigma^2 lambda_ hyperparameters
a1=.7
b1=.7
##Spacing dependence c in [0,1]
clam1=1
#####NumSplit
alpha1=3
J1max=10
####Split Point Starting Value ###
J1=3
##Tuning parameter for lambda
cl1=.25
###Beta Starting Values
beta1start=c(0,0,-1,0,0,0,1,1,1,1,1,-1,-1)
hyper=c(psi,c,z1a,z1b,a1,b1,clam1,alpha1,J1max,J1,cl1)
###Number of iterations and output location
B=200
Path=tempdir()
inc=2
burn=.4
PiecewiseBayesSelect(Y1,I1,X,hyper,beta1start,B,inc,Path,burn)
}

