% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/B2_LocalModelCompile.R
\name{LocalModelCompile}
\alias{LocalModelCompile}
\title{Model compilation}
\usage{
LocalModelCompile(data, dag = NULL, node.class = NULL)
}
\arguments{
\item{data}{a \code{data.frame} object or a \code{qtlnet} object}

\item{dag}{\code{NULL} if data is \code{qtlnet} object, or a \code{graphNEL} object of conditional
Gaussian Bayesian network if data is \code{data.frame}.}

\item{node.class}{\code{NULL} if data is \code{qtlnet} object, or a \code{vector} of logical values
named by node names, \code{TRUE} for discrete, \code{FALSE} for continuous variables if data
is \code{data.frame}.}
}
\value{
\describe{
\item{\code{pots}}{a \code{list} of discrete potentials (conditional probability tables)
for each discrete variable. }
\item{\code{bags}}{a \code{list} of sets of continuous potentials (lppotentials), each set for a
continuous variables.}
}
}
\description{
Compile the local models
}
\details{
This function compiles the local models, including the conditional
probability tables for discrete variables, and linear predictor potentials
for continuous variables. The qtlnet and qtl package need to be installed if data is
a \code{qtlnet} object.
}
\examples{

data(liver)
models <- LocalModelCompile(data=liver$data, dag=liver$dag, node.class=liver$node.class)

}
\references{
Cowell, R. G. (2005). Local propagation in conditional Gaussian Bayesian networks.
Journal of Machine Learning Research, 6(Sep), 1517-1550. \cr
\cr
Yu H, Moharil J, Blair RH (2020). BayesNetBP: An R Package for Probabilistic Reasoning in Bayesian
Networks. Journal of Statistical Software, 94(3), 1-31. <doi:10.18637/jss.v094.i03>.
}
\seealso{
\code{\link{ElimTreeInitialize}}
}
\author{
Han Yu
}
