% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_chain.R
\name{plot_chain}
\alias{plot_chain}
\title{Chain's plot}
\usage{
plot_chain(fit, param, type = c("trace", "acf", "density"))
}
\arguments{
\item{fit}{Object of the classes \code{HP} or \code{DLM}.}

\item{param}{Character vector specifying the parameters to be plotted. It is used only when the class of fit object is \code{DLM}.}

\item{type}{Character string specifying the type of plot to be returned. There are three options: "trace" return a plot for the sample of the parameters; "acf" return a plot for the autocorrelation of the parameters; "density" return a plot for the posterior density of the parameters based on the samples generated by the MCMC method.}
}
\value{
A plot of the chosen type of the selected parameter(s).
}
\description{
This function provides three options of plots for the chain generated by the MCMC
algorithm in hp() and dlm() functions.
}
\examples{
## Importing mortality data from the USA available on the Human Mortality Database (HMD):
\donttest{data(USA)

## Selecting the log mortality rate of the 2010 total population ranging from 0 to 90 years old
USA2010 = USA[USA$Year == 2010,]
x = 0:90
Ex = USA2010$Ex.Total[x+1]
Dx = USA2010$Dx.Total[x+1]
y = log(Dx/Ex)

## Fitting HP model
fit = hp(x = x, Ex = Ex, Dx = Dx, model = "lognormal",
         m = c(NA, 0.08, rep(NA, 6)),
         v = c(NA, 1e-4, rep(NA, 6)))

## Plotting all the available types of plot:
plot_chain(fit, type = "trace")
plot_chain(fit, type = "acf")
plot_chain(fit, type = "density")


## Fitting DLM
fit = dlm(y, M = 100)

plot_chain(fit, param = "sigma2", type = "trace")
plot_chain(fit, param = "mu[10]", type = "acf")

## Selecting all theta1 indexed with 1 in first digit
plot_chain(fit, param = "theta1[1", type = "density")

## Plotting all parameters indexed by age 10 and age 11
plot_chain(fit, param = c("[10]", "[11]"))
}

}
