% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fastGPfit.R
\name{GP.plot.curve}
\alias{GP.plot.curve}
\title{Graphical representation of one, two, three-dimensional
curves}
\usage{
GP.plot.curve(
  curve,
  xlab = NULL,
  ylab = NULL,
  zlab = NULL,
  xlim = NULL,
  ylim = NULL,
  zlim = NULL,
  col.regions = NULL,
  cut = NULL,
  num_slices = NULL,
  ...
)
}
\arguments{
\item{curve}{A list object with two elements:
\describe{
 \item{f}{A vector of real numbers for the curve.}
 \item{x}{A matrix of real numbers for the grid points where rows are observations and columns are coordinates.}
}}

\item{xlab}{A character specifying the label of x-axis for 1D, 2D and 3D case. The default value is NULL and set to "x" for 1D case and "x1" for 2D and 3D cases.}

\item{ylab}{A character specifying the label of y-axis for 1D curve or coords for 2D and 3D case.  The default value is NULL and set to "x2" for 2D and 3D cases.}

\item{zlab}{A character specifying the label of z-axis only for 3D case. The default value is NULL and set to "x3".}

\item{xlim}{A vector of two real numbers specifying the range of x-axis for 1D, 2D and 3D case. The default value is NULL and set to range(curve$x[,1]).}

\item{ylim}{A vector of two real numbers specifying the range of y-axis only for 2D, 3D case. The default value is NULL and set to range(curve$x[,2]).}

\item{zlim}{A vector of two real numbers specifying the range of z-axis only for 3D case. The default value is NULL and set to range(curve$x[,3]).}

\item{col.regions}{A vector of RGB colors for 2D and 3D plots. See \link{GP.create.cols}. The default value is NULL and set to GP.create.cols().}

\item{cut}{An integer specifying the number of colors in 2D and 3D plots. The default value is NULL and set to length(col.regions)-1.}

\item{num_slices}{An integer specifying the number of slices cutting through the 3rd dimension to show.}

\item{...}{All other parameters for plot (1D case) and levelplot (2D and 3D cases).}
}
\value{
NULL for 1D case. An object of class "trellis" for 2D and 3D cases.
}
\description{
Graphical representation of one, two, three-dimensional
curves
}
\examples{
library(BayesGPfit)
library(lattice)
set.seed(1224)
##plot 1D curve
x1d = GP.generate.grids(d=1,num_grids = 1000)
curve1d = GP.simulate.curve.fast(x1d,a=0.01,b=0.5,
                              poly_degree=10L)
GP.plot.curve(curve1d,main="Simulated 1D Curve")

##plot 2D curve
x2d = GP.generate.grids(d=2L,num_grids = 100)
curve2d = GP.simulate.curve.fast(x2d,a=0.01,b=0.5,
                              poly_degree=10L)
GP.plot.curve(curve2d,main="Simulated 2D Curve")

##plot 3D curve
x3d = GP.generate.grids(d=3,num_grids = 50)
curve3d = GP.simulate.curve.fast(x3d,a=0.01,b=0.5,
                              poly_degree=10L)
GP.plot.curve(curve3d,main="Simulated 3D Curve",num_slices=10,zlim=c(-0.5,0.5))
}
\author{
Jian Kang <jiankang@umich.edu>
}
