% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01_utility.R
\name{prior_conversion_sgp}
\alias{prior_conversion_sgp}
\title{Construct prior based on d-step prediction SD (for sgp)}
\usage{
prior_conversion_sgp(d, prior, freq, period, a, m = 1)
}
\arguments{
\item{d}{A numeric value for the prediction step.}

\item{prior}{A list that contains alpha and u. This specifies the target prior on the d-step SD \eqn{\sigma(d)}, such that \eqn{P(\sigma(d) > u) = alpha}.}

\item{freq}{The frequency of the sgp, ignored if a is provided.}

\item{period}{The period of the sgp, ignored if a or freq is provided.}

\item{a}{The frequency parameter of the sgp.}

\item{m}{The number of harmonics that should be considered, by default m = 1 represents only the sgp.}
}
\value{
A list that contains alpha and u. The prior for the smoothness parameter \eqn{\sigma} such that \eqn{P(\sigma > u) = alpha}, that yields the ideal prior on the d-step SD.
}
\description{
Construct prior based on d-step prediction SD (for sgp)
}
