% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/03_post_fit.R
\name{compute_post_fun_sgp}
\alias{compute_post_fun_sgp}
\title{Computing the posterior samples of the function using the posterior samples
of the basis coefficients for sGP}
\usage{
compute_post_fun_sgp(
  samps,
  global_samps = NULL,
  k,
  refined_x,
  a,
  region,
  boundary = TRUE,
  m,
  intercept_samps = NULL,
  initial_location = NULL
)
}
\arguments{
\item{samps}{A matrix that consists of posterior samples for the O-spline basis coefficients. Each column
represents a particular sample of coefficients, and each row is associated with one basis function. This can
be extracted using `sample_marginal` function from `aghq` package.}

\item{global_samps}{A matrix that consists of posterior samples for the global basis coefficients. If NULL,
assume there will be no global polynomials and the boundary conditions are exactly zero.}

\item{k}{The number of the sB basis.}

\item{refined_x}{A vector of locations to evaluate the sB basis}

\item{a}{The frequency of sGP.}

\item{region}{The region to define the sB basis}

\item{boundary}{A boolean variable to indicate whether the boundary condition should be considered in the prediction.}

\item{m}{The number of harmonics to consider}

\item{intercept_samps}{A matrix that consists of posterior samples for the intercept parameter. If NULL, assume there is no intercept samples to adjust.}

\item{initial_location}{The initial location of the sGP.}
}
\value{
A data.frame that contains different samples of the function, with the first column
being the locations of evaluations x = refined_x.
}
\description{
Computing the posterior samples of the function using the posterior samples
of the basis coefficients for sGP
}
