% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BSDA-package.R
\docType{data}
\name{Oxytocin}
\alias{Oxytocin}
\title{Arterial blood pressure of 11 subjects before and after receiving oxytocin}
\format{
A data frame/tibble with 11 observations on three variables
\describe{ 
\item{subject}{a numeric vector indicating each subject} 
\item{before}{mean arterial blood pressure of subject before receiving oxytocin} 
\item{after}{mean arterial blood pressure of subject after receiving oxytocin} 
}
}
\usage{
Oxytocin
}
\description{
Data for Exercise 7.86
}
\examples{

diff = Oxytocin$after - Oxytocin$before
qqnorm(diff)
qqline(diff)
shapiro.test(diff)
t.test(diff)
rm(diff)

}
\references{
Kitchens, L. J. (2003) \emph{Basic Statistics and Data Analysis}.
Pacific Grove, CA: Brooks/Cole, a division of Thomson Learning.
}
\keyword{datasets}
