% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BSDA-package.R
\docType{data}
\name{Fabric}
\alias{Fabric}
\title{Measures of softness of ten different clothing garments washed with and
without a softener}
\format{
A data frame/tibble with 20 observations on three variables
\describe{ 
\item{garment}{a numeric vector} 
\item{softner}{a character variable with values \code{with} and \code{without}} 
\item{softness}{a numeric vector} 
}
}
\usage{
Fabric
}
\description{
Data for Example 7.21
}
\examples{

\dontrun{
library(tidyr)
tidyr::spread(Fabric, softner, softness) -> FabricWide
wilcox.test(Pair(with, without)~1, alternative = "greater", data = FabricWide)
T7 <- tidyr::spread(Fabric, softner, softness) \%>\% 
mutate(di = with - without, adi = abs(di), rk = rank(adi), 
       srk = sign(di)*rk)
T7
t.test(T7$srk, alternative = "greater")
}
}
\references{
Kitchens, L. J. (2003) \emph{Basic Statistics and Data Analysis}.
Pacific Grove, CA: Brooks/Cole, a division of Thomson Learning.
}
\keyword{datasets}
