% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boptimal_n.R
\name{boptimal_n}
\alias{boptimal_n}
\title{Optimal Test Sample Size for Binomial RDT}
\usage{
boptimal_n(c, pi, R, thres_CR)
}
\arguments{
\item{c}{Maximum allowable failures}

\item{pi}{Failure probability}

\item{R}{Lower level reliability requirement}

\item{thres_CR}{Threshold (acceptable level) of consumer's risk}
}
\value{
Minimum test sample size
}
\description{
Define the optimal function to find the optimal test plan with minimum test sample size given an acceptable
level of consumer's risk (for binomial RDT).
}
\examples{
\donttest{
pi <- pi_MCSim_beta(M = 5000, seed = 10, a = 1, b = 1)
boptimal_n(c = 2, pi = pi, R = 0.8, thres_CR = 0.05)
}
}
\seealso{
\code{\link{boptimal_cost}} for getting the optial test plan with minimum overall cost;
\code{\link{bdata_generator}} for generating optimal test plans dataset;
}
