% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mains.R
\name{BOP2FE_nested}
\alias{BOP2FE_nested}
\title{BOP2-FE design for nested (ordinal) endpoint}
\usage{
BOP2FE_nested(
  H0,
  H1,
  n,
  nsim,
  t1e = NULL,
  method = "power",
  lambda1,
  lambda2,
  grid1,
  gamma1,
  gamma2,
  grid2,
  eta1 = NULL,
  eta2 = NULL,
  grid3 = NULL,
  seed = NULL
)
}
\arguments{
\item{H0}{A numeric vector representing the null response rates for different outcomes, specified in the following order:
- `H0[1]`: CR: Complete remission,
- `H0[2]`: PR: Partial remission,
- `H0[3]`: 1-(CR+PR)}

\item{H1}{A numeric vector representing the null response rates for different outcomes, specified in the following order:
- `H1[1]`: CR: Complete remission,
- `H1[2]`: PR: Partial remission,
- `H1[3]`: 1-(CR+PR)}

\item{n}{A numeric vector representing the additional patients enrolled at each interim analysis. 
The value at index `i` indicates the number of new patients added at interim analysis `i`. 
The total sample size at interim `i` is the cumulative sum of the values in `n` up to that index. 
For example, for four interim analyses with total sample sizes of 10, 15, 20, and 30, 
the vector would be represented as `n = c(10, 5, 5, 10)`, where:
- 10 is the number of patients enrolled at interim 1,
- 5 (15 - 10) is the additional number of patients enrolled at interim 2,
- 5 (20 - 15) is the additional number of patients enrolled at interim 3,
- 10 (30 - 20) is the additional number of patients enrolled at interim 4.}

\item{nsim}{number of simulation. A value at least 1000 for better result.}

\item{t1e}{Desired Type - I error rate. If specified it will only return results with type I error rate less the specified value}

\item{method}{A character string specifying the method to use for calculating cutoff values for the efficacy stopping.
Options are "power" (default) or "OF" for "O'Brien-Fleming".}

\item{lambda1}{starting value for `lambda` values to search.}

\item{lambda2}{ending value for `lambda` values to search.}

\item{grid1}{number of `lambda` values to consider between lambda1 and lambda2. A fine grid by 0.01 is recommended.}

\item{gamma1}{starting value for `gamma` values to search.}

\item{gamma2}{ending value for `gamma` values to search.}

\item{grid2}{number of `gamma` values to consider between gamma1 and gamma2. A fine grid by 0.01 is recommended.}

\item{eta1}{starting value for `eta` values to search.}

\item{eta2}{ending value for `eta` values to search.}

\item{grid3}{number of eta values to consider between eta1 and eta2. A fine grid by 0.01 is recommended.}

\item{seed}{for reproducibility}
}
\value{
An S3 object of class 'bop2fe'
}
\description{
Computes stopping boundaries and operating characteristics of Bayesian optimal phase II
design with efficacy and futility stopping for a nested (ordinal) endpoint
}
\examples{
 test_nested <- BOP2FE_nested(
 H0=c(0.15,0.15, 0.70),
 H1= c(0.25,0.25, 0.50),
 n = c(10, 5, 5),
 nsim = 1000, t1e = 0.1, method = "power",
 lambda1 = 0, lambda2 = 1, grid1 = 11,
 gamma1 = 0, gamma2 = 1, grid2 = 11,
 eta1 = 0, eta2 = 3, grid3 = 31,
 seed = 123)
 summary(test_nested)
#plot(test_nested)

}
\references{
Xu, X., Hashimoto, A., Yimer, B., & Takeda, K. (2025). BOP2-FE: Bayesian optimal phase II design with futility and efficacy stopping boundaries. Journal of Biopharmaceutical Statistics \doi{10.1080/10543406.2025.2558142}.
}
