% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MassCompartments.R
\name{MassCompartments}
\alias{MassCompartments}
\alias{AddMassCompartments}
\alias{RemoveMassCompartments}
\title{Add or remove mass compartments in a problem}
\usage{
AddMassCompartments(
  ThisProblem,
  MassTable = data.frame(),
  MassName = MassTable$Name,
  MassAmt = MassTable$Amt,
  MassUnit = MassTable$Unit,
  InMass = TRUE,
  DoCheck = TRUE
)

RemoveMassCompartments(ThisProblem, MCToRemove, DoCheck = TRUE)
}
\arguments{
\item{ThisProblem}{A list object with a structure like that returned by
`BlankProblem()`.}

\item{MassTable}{A `data.frame` object with, at a minimum, columns `Name`,
`Amt`, and `Unit`, defining the characteristics of the mass compartment(s)
to add.}

\item{MassName}{A character vector with the name(s) of the new mass
compartment(s).}

\item{MassAmt}{A numeric vector with the mass compartment amount(s).}

\item{MassUnit}{A character vector with the units for the amount(s) of the
mass compartment(s).}

\item{InMass}{A logical value or vector indicating if this mass compartment
is in the parameter file (`TRUE`, default) or was created as a result of,
e.g. the `ExpandWHAM` function (`FALSE`).}

\item{DoCheck}{A logical value indicating whether checks should be performed
on the incoming and outgoing problem objects. Defaults to `TRUE`, as you
usually want to make sure something isn't awry, but the value is often set
to `FALSE` when used internally (like in DefineProblem) so the problem is
only checked once at the end.}

\item{MCToRemove}{A character vector with names or indices of the mass
compartment(s) to remove from `ThisProblem`.}
}
\value{
`ThisProblem`, with all the edited mass compartments, along with any
  components, input variables, etc. associated with those mass compartments
  edited.
}
\description{
Add or remove mass compartments in a problem
}
\examples{
print(carbonate_system_problem$Mass)
my_new_problem = carbonate_system_problem
my_new_problem = AddMassCompartments(ThisProblem = my_new_problem,
                                     MassName = c("Soil", "BL"),
                                     MassAmt = 1,
                                     MassUnit = c("kg","kg wet"))
print(my_new_problem$Mass)
my_new_problem = RemoveMassCompartments(ThisProblem = my_new_problem,
                                        MCToRemove = "Soil")
print(my_new_problem$Mass)

}
\seealso{
Other problem manipulation functions: 
\code{\link{BlankProblem}()},
\code{\link{Components}},
\code{\link{CriticalValues}},
\code{\link{InLabs}},
\code{\link{InVars}},
\code{\link{Phases}},
\code{\link{SpecialDefs}},
\code{\link{Species}}
}
\concept{problem manipulation functions}
