% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_functions.R
\name{Check.Params}
\alias{Check.Params}
\title{Check Input Parameters}
\usage{
Check.Params(
  HLA,
  Loci.Set,
  Exon,
  All.Pairwise,
  Trim,
  Res,
  EVS.rm,
  Missing,
  Cores.Lim,
  Return,
  Output,
  Merge.Output,
  Verbose
)
}
\arguments{
\item{HLA}{Logical indicating whether data is HLA class I/II genotyping data only.}

\item{Loci.Set}{Input list defining which loci to use for analyses (combinations permitted).}

\item{Exon}{Numeric Exon(s) for targeted amino acid analysis.}

\item{All.Pairwise}{Logical indicating whether all pairwise loci should be analyzed in haplotype analysis.}

\item{Trim}{Logical indicating if HLA alleles should be trimmed to a set resolution.}

\item{Res}{Numeric setting what desired resolution to trim HLA alleles.}

\item{EVS.rm}{Logical indicating if expression variant suffixes should be removed.}

\item{Missing}{Numeric setting allowable missing data for running analysis (may use "ignore").}

\item{Cores.Lim}{Integer setting the number of cores accessible to BIGDAWG (Windows limit is 1 core).}

\item{Return}{Logical Should analysis results be returned as list.}

\item{Output}{Logical Should analysis results be written to output directory.}

\item{Merge.Output}{Logical Should analysis results be merged into a single file for easy access.}

\item{Verbose}{Logical Should a summary of each analysis be displayed in console.}
}
\description{
Check input parameters for invalid entries.
}
\note{
This function is for internal use only.
}
