% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/A_sampling.R
\name{A_sampling}
\alias{A_sampling}
\title{Regulation Strength Sampling Function}
\usage{
A_sampling(Y, C, A_old, X, base_line, C_prior, sigma_noise, sigma_A,
  sigma_baseline, sigma_X)
}
\arguments{
\item{Y}{gene expression data matrix}

\item{C}{sampled TF-gene binding network}

\item{A_old}{regulatory strength sampled from the previous round,
used as a prior in current function}

\item{X}{sampled transcription factor activity matrix}

\item{base_line}{sampled gene expression baseline activity}

\item{C_prior}{prior TF-gene binding network}

\item{sigma_noise}{variance of gene expression fitting residuals}

\item{sigma_A}{variance of regulatory strength}

\item{sigma_baseline}{variance of gene expression baseline activity}

\item{sigma_X}{variance of transcription factor activity}
}
\description{
Function 'A_sampling' estimates a regulation strength for each sampled binding event in C,
according to a posterior Gaussian distribution.
}
\keyword{Regulation_Strength}
