% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CuPlotDiag.R
\name{CuPlotDiag}
\alias{CuPlotDiag}
\title{Diagnosis plots for Lambda, U, C, Mu, Pi, Z and Epsilon}
\usage{
CuPlotDiag(M, variable = "Lambda", pos = 1)
}
\arguments{
\item{M}{List. Contains the output by \code{CuMRes}.}

\item{variable}{Either "Lambda", "U", "C", "Mu", "Pi", "Z" or "Epsilon".
Variable for which diagnostic plot will be shown.}

\item{pos}{Positive integer. Position of the selected \code{variable} to be
plotted.}
}
\description{
Diagnostics plots for hazard rate (Lambda), latent variable (U), dependence
variable (C), mean of cure threshold (Mu), cure proportion (Pi), cure threshold (Z) and the parameter of the
hierarchical prior (Epsilon).
}
\details{
This function returns a diagnostics plot for which the chain for the selected
variable can be monitored. Diagnostics includes trace, ergodic mean,
autocorrelation function and histogram.
}
\examples{



## Simulations may be time intensive. Be patient.

## Example 1
# data(crm3)
# times<-crm3$times
# delta<-crm3$delta
# res <- CuMRes(times, delta, type.t = 2, 
#                   K = 100, length = .1, alpha = rep(1, 100  ), 
#                   beta = rep(1, 100),c.r = rep(50, 99), 
#                   iterations = 100, burn.in = 10, thinning = 1, type.c = 2)
# CuPlotDiag(M = res, variable = "Mu")
# CuPlotDiag(M = res, variable = "Z")
# CuPlotDiag(M = res, variable = "Pi")
# CuPlotDiag(M = res, variable = "Lambda", pos = 2)
# CuPlotDiag(M = res, variable = "U", pos = 4)
# CuPlotDiag(M = res, variable = "C", pos = 3)



}
\references{
Nieto-Barajas, L. E., & Yin, G. (2008). Bayesian semiparametric
cure rate model with an unknown threshold. \emph{Scandinavian Journal of
Statistics}, \strong{35(3)}, 540-556.
https://doi.org/10.1111/j.1467-9469.2007.00589.x
}
\seealso{
\link{CuMRes}
}
