% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lm_plot.parms.R
\name{lm_plot.parms}
\alias{lm_plot.parms}
\title{Set or Retrieve Default Plot Parameters for Model Diagnostic Plots}
\usage{
lm_plot.parms(mdl, parms = list())
}
\arguments{
\item{mdl}{An object of class \code{lm}.}

\item{parms}{A list of plot parameters. Any missing or invalid entries are replaced with defaults.}
}
\value{
A list of plot element parameters with defaults filled in for any missing or invalid entries.
}
\description{
Initializes or updates a list of plot element parameters for use in model diagnostic plotting functions. If any required parameter is missing or invalid, a default value will be supplied.
}
\details{
The returned list contains parameters for points (size, color, shape), lines (type, color, size), options for plot features, Cook's distance/Influence contours, and seed values for sampling functions. These are used by other \code{lm_plot.*} functions to control plot appearance and annotation. Key defaults include:
\itemize{
  \item \strong{pts}: Properties for points (size, color, shape, outlier flags)
  \item \strong{lins}: Properties for lines (type, color, size)
  \item \strong{cook}: Cook's distance contour settings (points, levels, line type)
  \item \strong{infl}: Influence line settings (line type)
}
See function code for full list of available settings and default values.
}
\examples{
# Retrieve default parameters
parms <- lm_plot.parms(mdl = lm(Sepal.Length ~ Sepal.Width, data = iris))
# Set custom color for regular points
parms <- lm_plot.parms(mdl = lm(Sepal.Length ~ Sepal.Width, data = iris),
                       parms = list(pts = list(colr = list(reg = "blue"))))
}
\seealso{
\code{\link{lm_plot.fit}}, \code{\link{lm_plot.lev}}, \code{\link{lm_plot.infl}} \code{\link{outlier}}
}
