% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BALLI.v0.2.R
\name{balli}
\alias{balli}
\title{BALLI}
\usage{
balli(object, intV = 2, logcpm = NULL, tecVar = NULL,
  design = NULL, numCores = NULL, threshold = 1e-06, maxiter = 200)
}
\arguments{
\item{object}{a TecVarList object}

\item{intV}{numeric vector designating interest variable(s) which is(are) column number(s) of design matrix}

\item{logcpm}{logcpm values for each gene and each sample}

\item{tecVar}{estimated technical variance values for each gene and each sample}

\item{design}{design matrix with samples in row and covariable(s) to be estimated in column}

\item{numCores}{number of cores to be used for multithreding. If NULL, a single core is used}

\item{threshold}{threshold for convergence}

\item{maxiter}{maximum number of iteration to converge of estimated biological variance. If not, biological variance is estimated by using Brent method}
}
\value{
an Balli object including Result and topGenes list. Following components are shown by Result (same order of genes with input data) and topGenes (ordered by pBALLI in Result) :
\item{log2FC}{log2 fold changes of interest variable(s)}
\item{lLLI}{log-likelihoods estimated by LLI}
\item{lBALLI}{log-likelihoods estimated by BALLI}
\item{pLLI}{p-values estimated by LLI}
\item{pBALLI}{p-values estimated by BALLI}
\item{BCF}{Bartlett's correction factor}
expr <- data.frame(t(sapply(1:1000,function(x)rnbinom(20,mu=500,size=50))))
group <- c(rep("A",10),rep("B",10))
design <- model.matrix(~group, data = expr)
dge <- DGEList(counts=expr, group=group)
dge <- calcNormFactors(dge)
tV <- tecVarEstim(dge,design)
balli(tV,intV=2)
}
\description{
DEG analysis using BALLI algorithm
}
