% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_ef.R
\name{plot_ef}
\alias{plot_ef}
\title{Plot Efficiency Factor (EF) Trend}
\usage{
plot_ef(
  stoken,
  activity_type = c("Run", "Ride"),
  ef_metric = c("Pace_HR", "Power_HR"),
  start_date = NULL,
  end_date = NULL,
  min_duration_mins = 20,
  add_trend_line = TRUE,
  smoothing_method = "loess",
  ef_df = NULL
)
}
\arguments{
\item{stoken}{A valid Strava token from `rStrava::strava_oauth()`. Required unless `ef_df` is provided.}

\item{activity_type}{Type(s) of activities to analyze (e.g., "Run", "Ride").}

\item{ef_metric}{Metric to calculate: "Pace_HR" (Speed/HR) or "Power_HR" (Power/HR).}

\item{start_date}{Optional. Analysis start date (YYYY-MM-DD string or Date). Defaults to ~1 year ago.}

\item{end_date}{Optional. Analysis end date (YYYY-MM-DD string or Date). Defaults to today.}

\item{min_duration_mins}{Minimum activity duration (minutes) to include. Default 20.}

\item{add_trend_line}{Add a smoothed trend line (`geom_smooth`)? Default `TRUE`.}

\item{smoothing_method}{Smoothing method for trend line (e.g., "loess", "lm"). Default "loess".}

\item{ef_df}{Optional. A pre-calculated data frame from `calculate_ef`.
If provided, `stoken` and other calculation parameters are ignored.}
}
\value{
A ggplot object showing the EF trend.
}
\description{
Visualizes the trend of Efficiency Factor (EF) over time.
}
\details{
Plots the Efficiency Factor (EF) trend over time. Uses pre-calculated data
or calls `calculate_ef`.

Plots EF (output/HR based on activity averages). An upward trend
  often indicates improved aerobic fitness. Points colored by activity type.
  If `ef_df` is not provided, calls `calculate_ef` first.
}
\examples{
# Example using simulated data
data(Athlytics_sample_data)
# Explicitly name ef_df and provide activity_type
p <- plot_ef(ef_df = athlytics_sample_ef, activity_type = "Run") 
print(p)

\dontrun{
# Example using real data (requires authentication)
# stoken <- rStrava::strava_oauth("YOUR_APP_NAME",
#                                "YOUR_APP_CLIENT_ID",
#                                "YOUR_APP_SECRET",
#                                cache = TRUE)

# Plot Pace/HR EF trend for Runs (last 6 months)
# plot_ef(stoken = stoken, # Replace stoken with a valid token object
#         activity_type = "Run",
#         ef_metric = "Pace_HR",
#         start_date = Sys.Date() - months(6))

# Plot Power/HR EF trend for Rides
# plot_ef(stoken = stoken, # Replace stoken with a valid token object
#         activity_type = "Ride",
#         ef_metric = "Power_HR")

# Plot Pace/HR EF trend for multiple Run types (no trend line)
# plot_ef(stoken = stoken, # Replace stoken with a valid token object
#         activity_type = c("Run", "VirtualRun"),
#         ef_metric = "Pace_HR",
#         add_trend_line = FALSE)
}
}
