% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/black_scholes.R
\name{price_black_scholes_call}
\alias{price_black_scholes_call}
\title{Black-Scholes European Call Option Price}
\usage{
price_black_scholes_call(S0, K, r, sigma, time_to_maturity)
}
\arguments{
\item{S0}{Initial stock price (must be positive)}

\item{K}{Strike price (must be positive)}

\item{r}{Continuously compounded risk-free rate (e.g., 0.05 for 5\% annual rate)}

\item{sigma}{Volatility (annualized standard deviation, must be non-negative)}

\item{time_to_maturity}{Time to maturity in years (must be positive)}
}
\value{
European call option price (numeric)
}
\description{
Computes the exact price of a European call option using the classical
Black-Scholes (1973) analytical formula. This is the continuous-time
benchmark for comparison with discrete binomial models.
}
\details{
The Black-Scholes formula for a European call option is:
\deqn{C = S_0 N(d_1) - K e^{-rT} N(d_2)}

where:
\deqn{d_1 = \frac{\log(S_0/K) + (r + \sigma^2/2)T}{\sigma\sqrt{T}}}
\deqn{d_2 = d_1 - \sigma\sqrt{T}}

and \eqn{N(\cdot)} is the cumulative standard normal distribution function.

This formula assumes:
\itemize{
  \item Stock price follows geometric Brownian motion: \eqn{dS_t = rS_t dt + \sigma S_t dW_t}
  \item No dividends
  \item Constant risk-free rate and volatility
  \item Continuous trading with no transaction costs or price impact
}
}
\examples{
price_black_scholes_call(S0 = 100, K = 100, r = 0.05, sigma = 0.2,
                         time_to_maturity = 1)

}
\references{
Black, F., & Scholes, M. (1973). The Pricing of Options and Corporate Liabilities.
\emph{Journal of Political Economy}, 81(3), 637-654.
\doi{10.1086/260062}
}
