% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/csv.R
\name{data_frame_from_forecast_data}
\alias{data_frame_from_forecast_data}
\title{Converts forecast data from Zoltar's native \code{list} format to a \code{data.frame}}
\usage{
data_frame_from_forecast_data(forecast_data)
}
\arguments{
\item{forecast_data}{Forecast data as a \code{list} in the Zoltar standard format}
}
\value{
A \code{data.frame} from forecast_data in zoltar-specific format. The columns are:
'unit', 'target', 'class', 'value', 'cat', 'prob', 'sample', 'quantile', 'family',
'param1', 'param2', 'param3'. They are documented at
https://docs.zoltardata.com/fileformats/#forecast-data-format-csv .
NB: columns are all character (i.e., data type information from forecast_data is lost). Also note that a retracted
prediction element is represented as a single row with NA values for all but the first four columns.
}
\description{
Converts forecast data from Zoltar's native \code{list} format to a \code{data.frame}
}
\examples{
\dontrun{
  forecast_data <- jsonlite::read_json("docs-predictions.json")
  data_frame <- data_frame_from_forecast_data(forecast_data)
}
}
