% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zipfpss.R
\name{zipfpss}
\alias{zipfpss}
\alias{dzipfpss}
\alias{dzipfpss}
\alias{pzipfpss}
\alias{rzipfpss}
\alias{qzipfpss}
\title{The Zipf-Poisson Stop Sum Distribution (Zipf-PSS).}
\usage{
dzipfpss(x, alpha, lambda, log = FALSE, isTruncated = FALSE)

pzipfpss(q, alpha, lambda, log.p = FALSE, lower.tail = TRUE,
  isTruncated = FALSE)

rzipfpss(n, alpha, lambda, log.p = FALSE, lower.tail = TRUE,
  isTruncated = FALSE)

qzipfpss(p, alpha, lambda, log.p = FALSE, lower.tail = TRUE,
  isTruncated = FALSE)
}
\arguments{
\item{x, q}{Vector of positive integer values.}

\item{alpha}{Value of the \eqn{\alpha} parameter (\eqn{\alpha > 1} ).}

\item{lambda}{Value of the \eqn{\lambda} parameter (\eqn{\lambda > 0} ).}

\item{log, log.p}{Logical; if TRUE, probabilities p are given as log(p).}

\item{isTruncated}{Logical; if TRUE, the zero truncated version of the distribution is returned.}

\item{lower.tail}{Logical; if TRUE (default), probabilities are \eqn{P[X \leq x]}, otherwise, \eqn{P[X > x]}.}

\item{n}{Number of random values to return.}

\item{p}{Vector of probabilities.}
}
\description{
Probability mass function, cumulative distribution function, quantile function and random number
generation for the Zipf-PSS distribution with parameters \eqn{\alpha} and \eqn{\lambda}. The support of the Zipf-PSS
distribution are the positive integer numbers including the zero value. In order to work with its zero-truncated version
the parameter \code{isTruncated} should be equal to True.
}
\details{
The support of the \eqn{\lambda} parameter increases when the distribution is truncated at zero being
\eqn{\lambda \geq 0}. It has been proved that when \eqn{\lambda = 0} one has the degenerated version of the distribution at one.
}
\references{
{
Panjer, H. H. (1981). Recursive evaluation of a family of compound
distributions. ASTIN Bulletin: The Journal of the IAA, 12(1), 22-26.

Sundt, B., & Jewell, W. S. (1981). Further results on recursive evaluation of
compound distributions. ASTIN Bulletin: The Journal of the IAA, 12(1), 27-39.
}
}
