% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zipcode.R
\name{read_zipcode}
\alias{read_zipcode}
\title{Read Japan post's zip-code file}
\usage{
read_zipcode(path, type = c("oogaki", "kogaki", "roman", "jigyosyo"))
}
\arguments{
\item{path}{local file path or zip file URL}

\item{type}{Input file type, one of "oogaki", "kogaki", "roman", "jigyosyo"}
}
\value{
\link[tibble:tibble]{tibble}
}
\description{
\Sexpr[results=rd, stage=render]{lifecycle::badge("experimental")}
}
\details{
Reads zip-code data in csv format provided by japan post group and parse it as a data.frame.
Corresponds to the available "oogaki", "kogaki", "roman" and "jigyosyo" types.
These file types must be specified by the argument.
}
\examples{
# Input sources
read_zipcode(path = system.file("zipcode_dummy/13TOKYO_oogaki.CSV", package = "zipangu"),
             type = "oogaki")
read_zipcode(system.file("zipcode_dummy/13TOKYO_kogaki.CSV", package = "zipangu"),
             "oogaki")
read_zipcode(system.file("zipcode_dummy/KEN_ALL_ROME.CSV", package = "zipangu"),
             "roman")
read_zipcode(system.file("zipcode_dummy/JIGYOSYO.CSV", package = "zipangu"),
             "jigyosyo")
\dontrun{
# Or directly from a URL
read_zipcode("https://www.post.japanpost.jp/zipcode/dl/jigyosyo/zip/jigyosyo.zip")
}
}
\seealso{
\url{https://www.post.japanpost.jp/zipcode/dl/readme.html},
\url{https://www.post.japanpost.jp/zipcode/dl/jigyosyo/readme.html}
}
