% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/delete_mirror.R
\name{delete_mirror}
\alias{delete_mirror}
\title{Delete a deposit mirror}
\usage{
delete_mirror(deposit_id, cache_type = NULL)
}
\arguments{
\item{deposit_id}{numeric. The Zenodo deposit id.}

\item{cache_type}{character. If \code{NULL}, the package will check the enviroment variable \code{zendown_cache_type} setting and use it. If \code{zendown_cache_type} is not set, the function will default to a temporary cache. The argument can be set to \code{temporary} to store the cache in a temporary system folder and \code{persistent} to store the cache in a persistent system folder.}
}
\value{
No return value. The function deletes mirrored on the system.
}
\description{
This function will delete all mirrored files stored locally.
}
\examples{
\dontshow{if (curl::has_internet() & RCurl::url.exists("https://zenodo.org/records/10959197", timeout.ms = 5000)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# https://zenodo.org/records/10959197
file_path <- zen_file(10959197, "iris.rds")
print(file_path)
file.exists(file_path)
delete_mirror(10959197)
file.exists(file_path)
\dontshow{\}) # examplesIf}
}
