% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/range.R
\name{rangeInput}
\alias{rangeInput}
\alias{updateRangeInput}
\title{Range input}
\usage{
rangeInput(id, min = 0, max = 100, default = min, step = 1, ...)

updateRangeInput(
  id,
  value = NULL,
  enable = NULL,
  disable = NULL,
  session = getDefaultReactiveDomain()
)
}
\arguments{
\item{id}{A character string specifying the id of the reactive input.}

\item{min}{A number specifying the minimum value of the input, defaults to
\code{0}.}

\item{max}{A number specifying the maximum value of the input, defaults to
\code{100}.}

\item{default}{A number between \code{min} and \code{max} specifying the default value
of the input, defaults to \code{min}.}

\item{step}{A number specifying the interval step of the input, defaults to
\code{1}.}

\item{...}{Additional named arguments passed as HTML attributes to the
parent element or tag elements passed as child elements to the parent
element.}

\item{value}{A number specifying a new value for the input, defaults to
\code{NULL}.}

\item{enable}{One of \code{values} specifying particular choices to enable or
\code{TRUE} specifying the entire input is enabled, defaults to \code{NULL}.}

\item{disable}{One of \code{values} specifying particular choices to disable or
\code{TRUE} specifying the entire input is disabled, defaults to \code{NULL}.}

\item{session}{A reactive context, defaults to \code{\link[=getDefaultReactiveDomain]{getDefaultReactiveDomain()}}.}
}
\description{
\code{rangeInput()} creates a simple numeric range input.
}
\details{
The sophistication of this input will improve as browsers adopt the latest
HTML standards.
}
\examples{

### Range inputs

# Select from a range of numeric values.

rangeInput(id = "range1")

### Custom step

rangeInput(id = "range2", step = 10)

}
\seealso{
Other inputs: 
\code{\link{buttonGroupInput}()},
\code{\link{buttonInput}()},
\code{\link{checkbarInput}()},
\code{\link{checkboxInput}()},
\code{\link{chipInput}()},
\code{\link{fileInput}()},
\code{\link{formInput}()},
\code{\link{listGroupInput}()},
\code{\link{menuInput}()},
\code{\link{navInput}()},
\code{\link{radioInput}()},
\code{\link{radiobarInput}()},
\code{\link{selectInput}()},
\code{\link{textInput}()}
}
\concept{inputs}
