% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/menu.R
\name{menuInput}
\alias{menuInput}
\alias{updateMenuInput}
\title{Menu inputs}
\usage{
menuInput(id, label, choices = NULL, values = choices,
  selected = NULL, ..., direction = "down", align = "left")

updateMenuInput(id, choices = NULL, values = choices,
  selected = NULL, enable = NULL, disable = NULL,
  session = getDefaultReactiveDomain())
}
\arguments{
\item{id}{A character string specifying the id of the reactive input.}

\item{label}{A character string or tag element specifying the label of the
menu's toggle button.}

\item{choices}{A character vector specifying the choice text of the menu's
items.}

\item{values}{A character vector specifying the values of the menu's items,
defaults to \code{choices}.}

\item{selected}{One or more of \code{values} specifying which choices are
selected by default, defaults to \code{NULL}, in which case no choices are
initially selected.}

\item{...}{Additional named arguments passed as HTML attributes to the
parent element or tag elements passed as child elements to the parent
element.}

\item{direction}{One of \code{"up"}, \code{"right"}, \code{"down"}, or \code{"left"} specifying
which direction the menu opens, defaults to \code{"down"}.}

\item{align}{One or \code{"right"} or \code{"left"} specifying which side of the
toggle button the menu aligns to, defaults to \code{"left"}.`}

\item{enable}{One of \code{values} specifying particular choices to enable or
\code{TRUE} specifying the entire input is enabled, defaults to \code{NULL}.}

\item{disable}{One of \code{values} specifying particular choices to disable or
\code{TRUE} specifying the entire input is disabled, defaults to \code{NULL}.}

\item{session}{A reactive context, defaults to \code{\link[=getDefaultReactiveDomain]{getDefaultReactiveDomain()}}.}
}
\description{
A togglable dropdown menu input. Menu inputs may be used as standalone
reactive inputs or within a \code{\link[=navInput]{navInput()}}. For building custom, more complex
dropdown elements please see \code{\link[=dropdown]{dropdown()}}.
}
\examples{

### A simple menu

menuInput(
  id = "menu1",
  label = "Menu",
  choices = c(
    "Choice 1",
    "Choice 2",
    "Choice 3"
  )
)

### Use in navigation

navInput(
  id = "nav1",
  choices = list(
    "Tab 1",
    menuInput(
      id = "navOptions",
      label = "Tab 2",
      choices = c(
        "Option 1",
        "Option 2",
        "Option 3"
      )
    ),
    "Tab 3",
    "Tab 4"
  ),
  values = paste0("tab", 1:4)
)

}
\seealso{
Other inputs: \code{\link{buttonGroupInput}},
  \code{\link{buttonInput}}, \code{\link{checkbarInput}},
  \code{\link{checkboxInput}}, \code{\link{chipInput}},
  \code{\link{fileInput}}, \code{\link{formInput}},
  \code{\link{listGroupInput}}, \code{\link{navInput}},
  \code{\link{radioInput}}, \code{\link{radiobarInput}},
  \code{\link{rangeInput}}, \code{\link{selectInput}},
  \code{\link{textInput}}
}
\concept{inputs}
