% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/yesno.R
\name{yesno}
\alias{yesno}
\title{Yes No with Variable Responses}
\usage{
yesno(...)
}
\arguments{
\item{...}{Objects to paste and then output to produce the question.}
}
\value{
A flag indicating whether the user answered yes or no.
}
\description{
Asks a custom yes-no question with randomly varying responses.
Returns a flag indicating whether the user answered yes or no.
It is designed to be used in situations where the users needs to confirm
an affirmative action.
}
\details{
The objects are first pasted without separators
and collapsed using \code{\link{paste0}(..., collapse = "")}
before being output using \code{\link{cat}}.

The order and phrasing of the possible responses varies randomly to ensure
the user consciously chooses (as opposed to automatically types their response).

A total of three responses are offered - two of which correspond to No and
one of which corresponds to Yes.
The possible responses are skewed to No to reduce the chances that a blindly-typing
user mistakenly chooses an affirmative action.
For the same reason, selection of uncertain responses such as 'Uhhh... Maybe?'
is considered to be a No.
Selection of a 0 (to exit) is also considered to be No.
Questions should be phrased accordingly.
}
\examples{
\dontrun{
yesno("Do you like ", R.Version()$nickname ,"?")
}
}
\seealso{
\code{\link{yesno2}}
}
