% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trim.R
\name{trim_common}
\alias{trim_common}
\title{Trim lineages until the shallowest common rank.}
\usage{
trim_common(lineage, remove_void = TRUE, only_tail = TRUE)
}
\arguments{
\item{lineage}{string. Vector of lineages.}

\item{remove_void}{Should void ranks be removed? Default to \code{TRUE}.}

\item{only_tail}{Logical to be passed to \code{trim_void()}. Used only if
\code{remove_void} is set to \code{TRUE}.}
}
\value{
The trimmed lineages, with same depth.
}
\description{
Trim lineages until the shallowest common rank.
}
\examples{
lineage1 <- "k__Bacteria|p__Verrucomicrobia|c__Verrucomicrobiae"
lineage2 <- "k__Bacteria|p__Firmicutes"
lineage3 <- "k__Bacteria|p__|c__Clostridia"
trim_common(c(lineage1, lineage2, lineage3), remove_void = FALSE)
trim_common(c(lineage1, lineage2, lineage3), only_tail = FALSE)
}
