% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sensitivity.R
\name{sens}
\alias{sens}
\alias{sens.default}
\alias{sens.table}
\alias{sens.matrix}
\alias{spec}
\alias{spec.default}
\alias{spec.table}
\alias{spec.matrix}
\alias{ppv}
\alias{ppv.default}
\alias{ppv.table}
\alias{ppv.matrix}
\alias{npv}
\alias{npv.default}
\alias{npv.table}
\alias{npv.matrix}
\alias{sens.data.frame}
\alias{sens.table}
\alias{sens.matrix}
\alias{spec.data.frame}
\alias{ppv}
\alias{ppv.table}
\alias{ppv.matrix}
\alias{npv}
\alias{npv.table}
\alias{npv.matrix}
\title{Calculate sensitivity, specificity and predictive values}
\usage{
sens(data, ...)

\method{sens}{data.frame}(data, truth, estimate, na.rm = TRUE, ...)

\method{sens}{table}(data, ...)

\method{sens}{matrix}(data, ...)

\method{spec}{data.frame}(data, truth, estimate, na.rm = TRUE, ...)

ppv(data, ...)

\method{ppv}{table}(data, prevalence = NULL, ...)

\method{ppv}{matrix}(data, prevalence = NULL, ...)

npv(data, ...)

\method{npv}{table}(data, prevalence = NULL, ...)

\method{npv}{matrix}(data, prevalence = NULL, ...)
}
\arguments{
\item{data}{For the default functions, a factor containing the
discrete measurements. For the \code{table} or \code{matrix}
functions, a table or matrix object, respectively, where the
true class results should be in the columns of the table.}

\item{...}{Not currently used.}

\item{truth}{The column identifier for the true class results
(that is a factor). This should an unquoted column name although
this argument is passed by expression and support
\link[rlang:quasiquotation]{quasiquotation} (you can unquote column
names or column positions).}

\item{estimate}{The column identifier for the predicted class
results (that is also factor). As with \code{truth} this can be
specified different ways but the primary method is to use an
unquoted variable name.}

\item{na.rm}{A logical value indicating whether \code{NA}
values should be stripped before the computation proceeds}

\item{prevalence}{A numeric value for the rate of the
"positive" class of the data.}
}
\value{
A number between 0 and 1 (or NA).
}
\description{
These functions calculate the sensitivity, specificity or
predictive values of a measurement system compared to a
reference results (the truth or a gold standard). The
measurement and "truth" data must have the same two possible
outcomes and one of the outcomes must be thought of as a
"positive" results or the "event".
}
\details{
The sensitivity is defined as the proportion of positive
results out of the number of samples which were actually
positive. When there are no positive results, sensitivity is not
defined and a value of \code{NA} is returned. Similarly, when
there are no negative results, specificity is not defined and a
value of \code{NA} is returned. Similar statements are true for
predictive values.

The positive predictive value is defined as the percent of
predicted positives that are actually positive while the
negative predictive value is defined as the percent of negative
positives that are actually negative.

There is no common convention on which factor level should
automatically be considered the "event" or "positive" results.
In \code{yardstick}, the default is to use the \emph{first} level. To
change this, a global option called \code{yardstick.event_first} is
set to \code{TRUE} when the package is loaded. This can be changed
to \code{FALSE} if the last level of the factor is considered the
level of interest.

Suppose a 2x2 table with notation

\tabular{rcc}{ \tab Reference \tab \cr Predicted \tab Event \tab No Event
\cr Event \tab A \tab B \cr No Event \tab C \tab D \cr }

The formulas used here are: \deqn{Sensitivity = A/(A+C)} \deqn{Specificity =
D/(B+D)} \deqn{Prevalence = (A+C)/(A+B+C+D)} \deqn{PPV = (sensitivity *
Prevalence)/((sensitivity*Prevalence) + ((1-specificity)*(1-Prevalence)))}
\deqn{NPV = (specificity * (1-Prevalence))/(((1-sensitivity)*Prevalence) +
((specificity)*(1-Prevalence)))}

See the references for discussions of the statistics.

If more than one statistic is required, it is more
computationally efficient to create the confusion matrix using
\code{\link[=conf_mat]{conf_mat()}} and applying the corresponding \code{summary} method
(\code{\link[=summary.conf_mat]{summary.conf_mat()}}) to get the values at once.
}
\examples{
data("two_class_example")

# Given that a sample is Class 1, 
#   what is the probability that is predicted as Class 1? 
sens(two_class_example, truth = truth, estimate = predicted)

# Given that a sample is predicted to be Class 1, 
#  what is the probability that it truly is Class 1? 
ppv(two_class_example, truth = truth, estimate = predicted)

# But what if we think that Class 1 only occurs 40\% of the time?
ppv(two_class_example, truth, predicted, prevalence = 0.40) 
}
\references{
Altman, D.G., Bland, J.M. (1994) ``Diagnostic tests 1:
sensitivity and specificity,'' \emph{British Medical Journal},
vol 308, 1552.

Altman, D.G., Bland, J.M. (1994) ``Diagnostic tests 2:
predictive values,'' \emph{British Medical Journal}, vol 309,
102.
}
\seealso{
\code{\link[=conf_mat]{conf_mat()}}, \code{\link[=summary.conf_mat]{summary.conf_mat()}}, \code{\link[=recall]{recall()}}, \code{\link[=mcc]{mcc()}}
}
\keyword{manip}
