% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parseable.R
\name{is_parseable.default}
\alias{is_parseable.default}
\title{Check Something is Parseable as Units by Default}
\usage{
\method{is_parseable}{default}(x, ...)
}
\arguments{
\item{x}{character}

\item{...}{passed arguments}
}
\value{
logical
}
\description{
Checks if something is parseable as units.
Tests against the udunits library in \pkg{units}.
See \code{\link[units]{as_units}}.
See also \code{\link[units]{install_unit}}
for finer control.
}
\examples{
is_parseable(c('kg/m2','kg/m^2','kg.m/s2','µg/L'))
is_parseable('foo')
library(units)
install_unit('foo')
is_parseable('foo')

}
\seealso{
Other parseable: 
\code{\link{is_parseable}()}

Other interface: 
\code{\link{canonical.decorated}()},
\code{\link{classified.data.frame}()},
\code{\link{decorate.character}()},
\code{\link{decorate.data.frame}()},
\code{\link{desolve.decorated}()},
\code{\link{ggplot.decorated}()},
\code{\link{io_csv.character}()},
\code{\link{io_csv.data.frame}()},
\code{\link{io_res.character}()},
\code{\link{io_res.decorated}()},
\code{\link{io_table.character}()},
\code{\link{io_table.data.frame}()},
\code{\link{io_yamlet.character}()},
\code{\link{io_yamlet.data.frame}()},
\code{\link{mimic.default}()},
\code{\link{modify.default}()},
\code{\link{promote.list}()},
\code{\link{read_yamlet}()},
\code{\link{resolve.decorated}()},
\code{\link{selected.default}()},
\code{\link{write_yamlet}()}
}
\concept{interface}
\concept{parseable}
\keyword{internal}
