% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/yamlet.R
\name{as.character.yamlet}
\alias{as.character.yamlet}
\title{Coerce Yamlet to Character}
\usage{
\method{as.character}{yamlet}(x, sort = TRUE, ...)
}
\arguments{
\item{x}{yamlet}

\item{sort}{whether to coerce attribute order using \code{\link{canonical.yamlet}}}

\item{...}{passed to \code{\link{as.character.yam}} and \code{\link{as_yam.yamlet}}}
}
\value{
character
}
\description{
Coerces yamlet to character.  See also \code{\link{as_yamlet.character}}.
}
\examples{

as.character(as_yamlet('ID: subject identifier'))
as.character(as_yamlet(c('id: subject','amt: dose')))
as.character(as_yamlet(c('id: subject\namt: dose')))
foo <- as_yamlet(system.file(package = 'yamlet', 'extdata','quinidine.yaml'))
class(foo)
writeLines(as.character(foo))
identical(foo, as_yamlet(as.character(foo)))
identical(as.character(foo), as.character(as_yamlet(as.character(foo))))
file <- system.file(package = 'yamlet','extdata','quinidine.csv')
file
foo <- resolve(decorate(file))
as.character(as_yamlet(foo))
as.character(as_yamlet(foo, exclude_attr = 'class'))

}
\seealso{
Other yamlet: 
\code{\link{[.yamlet}()},
\code{\link{as_yamlet.character}()},
\code{\link{as_yamlet.data.frame}()},
\code{\link{as_yamlet.list}()},
\code{\link{as_yamlet.yamlet}()},
\code{\link{as_yamlet.yam}()},
\code{\link{as_yamlet}()},
\code{\link{print.yamlet}()}
}
\concept{yamlet}
\keyword{internal}
